angular.module('focaModalCobradores')
    .controller('focaModalCobradoresController', [
        '$timeout',
        '$filter',
        '$scope',
        '$uibModalInstance',
        'focaModalCobradoresService',
        function($timeout, $filter, $scope, $uibModalInstance, focaModalCobradoresService) {

            $scope.filters = '';
            $scope.cobradores = [];
            $scope.primerBusqueda = false;
            $scope.searchLoading = false;
            // pagination
            $scope.numPerPage = 10;
            $scope.currentPage = 1;
            $scope.filteredCobradores = [];
            $scope.currentPageCobradores = [];
            $scope.selectedCobrador = -1;

            $scope.busquedaPress = function(key) {
                if (key === 13) {
                    $scope.searchLoading = true;
                    focaModalCobradoresService.getCobradores($scope.filters).then(
                        function(res) {
                            $scope.searchLoading = false;
                            $scope.primerBusqueda = true;
                            $scope.cobradores = res.data;
                            $scope.search(true);
                            primera();
                        }
                    );
                }
            };

            $scope.search = function(pressed) {
                
                if($scope.cobradores.length > 0) {
                    $scope.filteredCobradores = $filter('filter')(
                    $scope.cobradores, { $: $scope.filters }
                    );
                    $scope.lastPage = Math.ceil(
                        $scope.filteredCobradores.length / $scope.numPerPage
                    );
                    $scope.resetPage();
                    if(pressed && $scope.filteredCobradores.length === 0) {
                        $timeout(function() {
                            angular.element('#search')[0].focus();
                            $scope.filters = '';
                        });
                    }
                }
            };

            $scope.resetPage = function() {
                $scope.currentPage = 1;
                $scope.selectPage(1);
            };

            $scope.selectPage = function(page) {
                var start = (page - 1) * $scope.numPerPage;
                var end = start + $scope.numPerPage;
                $scope.paginas = [];
                $scope.paginas = calcularPages(page);
                $scope.currentPageCobradores = $scope.filteredCobradores.slice(start, end);
                $scope.currentPage = page;
            };

            $scope.select = function(vendedor) {
                $uibModalInstance.close(vendedor);
            };

            $scope.cancel = function() {
                $uibModalInstance.dismiss('cancel');
            };

            $scope.busquedaDown = function(key) {
                if (key === 40) {
                    primera(key);
                }
            };

            $scope.itemCobrador = function(key) {
                if (key === 38) {
                    anterior(key);
                }

                if (key === 40) {
                    siguiente(key);
                }

                if (key === 37) {
                    retrocederPagina();
                }

                if (key === 39) {
                    avanzarPagina();
                }
            };

            function calcularPages(paginaActual) {
                var paginas = [];
                paginas.push(paginaActual);

                if (paginaActual - 1 > 1) {

                    paginas.unshift(paginaActual - 1);
                    if (paginaActual - 2 > 1) {
                        paginas.unshift(paginaActual - 2);
                    }
                }

                if (paginaActual + 1 < $scope.lastPage) {
                    paginas.push(paginaActual + 1);
                    if (paginaActual + 2 < $scope.lastPage) {
                        paginas.push(paginaActual + 2);
                    }
                }

                if (paginaActual !== 1) {
                    paginas.unshift(1);
                }

                if (paginaActual !== $scope.lastPage) {
                    paginas.push($scope.lastPage);
                }

                return paginas;
            }

            function primera() {
                $scope.selectedCobrador = 0;
            }

            function anterior() {
                if ($scope.selectedCobrador === 0 && $scope.currentPage > 1) {
                    retrocederPagina();
                } else {
                    $scope.selectedCobrador--;
                }
            }

            function siguiente() {
                if ($scope.selectedCobrador < $scope.currentPageCobradores.length - 1) {
                    $scope.selectedCobrador++;
                } else {
                    avanzarPagina();
                }
            }

            function retrocederPagina() {
                if ($scope.currentPage > 1) {
                    $scope.selectPage($scope.currentPage - 1);
                    $scope.selectedCobrador = $scope.numPerPage - 1;
                }
            }

            function avanzarPagina() {
                if ($scope.currentPage < $scope.lastPage) {
                    $scope.selectPage($scope.currentPage + 1);
                    $scope.selectedCobrador = 0;
                }
            }
        }]
    );
