angular.module('focaModalHojaRuta')
    .controller('focaModalHojaRutaController', 
        [
            '$filter',
            '$scope',
            '$uibModalInstance',
            'focaModalHojaRutaService',
            function($filter, $scope, $uibModalInstance, focaModalHojaRutaService) {
                var fecha = new Date();
                $scope.fechaHasta = new Date();
                $scope.fechaDesde = new Date(fecha.setMonth(fecha.getMonth() - 1));
                $scope.filters = '';
                $scope.HojaRuta = [];
                $scope.primerBusqueda = false;
                $scope.searchLoading = false;
                // pagination
                $scope.numPerPage = 10;
                $scope.currentPage = 1;
                $scope.filteredHojaRuta = [];
                $scope.currentPageHojaRuta = [];
                $scope.selectedHojaRuta = -1;

                //METODOS
                $scope.busquedaPress = function(key) {
                    if (key === 13) {
                        //TODO Validaciones con alertas de foca
                        if(!$scope.fechaDesde) {
                            alert('INGRESE FECHA DESDE');
                            return;
                        }
                        if(!$scope.fechaHasta) {
                            alert('INGRESE FECHA HASTA');
                            return;
                        }
                        if($scope.fechaDesde > $scope.fechaHasta) {
                            alert('La fecha desde no puede ser mayor a la fecha hasta');
                            return;
                        }
                        $scope.searchLoading = true;
                        //TODO: usar filtros en vez de toISOString
                        focaModalHojaRutaService
                            .getHojasRuta($scope.fechaDesde.toISOString().split('.')[0],
                                $scope.fechaHasta.toISOString().split('.')[0])
                            .then(llenarDatos);
                    }
                };
                function llenarDatos(res) {
                    $scope.HojaRuta = [];
                    $scope.filteredHojaRuta = [];
                    $scope.currentPageHojaRuta = [];
                    $scope.selectedHojaRuta = -1;
                    $scope.searchLoading = false;
                    $scope.primerBusqueda = true;
                    $scope.HojaRuta = res.data;
                    $scope.search();
                    primera();
                }
                $scope.search = function() {
                    if($scope.HojaRuta.length > 0) {
                        $scope.filteredHojaRuta = $filter('filter')(
                            $scope.HojaRuta,
                            {$: $scope.filters}
                        );

                        $scope.lastPage = Math.ceil(
                            $scope.filteredHojaRuta.length / $scope.numPerPage
                        );

                        $scope.resetPage();
                    }
                };

                $scope.resetPage = function() {
                    $scope.currentPage = 1;
                    $scope.selectPage(1);
                };

                $scope.selectPage = function(page) {
                    var start = (page - 1) * $scope.numPerPage;
                    var end = start + $scope.numPerPage;
                    $scope.paginas = [];
                    $scope.paginas = calcularPages(page);
                    $scope.currentPageHojaRuta = $scope.filteredHojaRuta.slice(start, end);
                    $scope.currentPage = page;
                };

                $scope.select = function(remito) {
                    $uibModalInstance.close(remito);
                };

                $scope.cancel = function() {
                    $uibModalInstance.dismiss('cancel');
                };

                $scope.busquedaDown = function(key) {
                    if (key === 40) {
                        primera(key);
                    }
                };

                $scope.itemRemito = function(key) {
                    if (key === 38) {
                        anterior(key);
                    }

                    if (key === 40) {
                        siguiente(key);
                    }

                    if (key === 37) {
                        retrocederPagina();
                    }

                    if (key === 39) {
                        avanzarPagina();
                    }
                };

                function calcularPages(paginaActual) {
                    var paginas = [];
                    paginas.push(paginaActual);

                    if (paginaActual - 1 > 1) {
                        
                        paginas.unshift(paginaActual - 1);
                        if (paginaActual - 2 > 1) {
                            paginas.unshift(paginaActual - 2);
                        }
                    }

                    if (paginaActual + 1 < $scope.lastPage) {
                        paginas.push(paginaActual + 1);
                        if (paginaActual + 2 < $scope.lastPage) {
                            paginas.push(paginaActual + 2);
                        }
                    }

                    if (paginaActual !== 1) {
                        paginas.unshift(1);
                    }

                    if (paginaActual !== $scope.lastPage) {
                        paginas.push($scope.lastPage);
                    }

                    return paginas;
                }

                function primera() {
                    $scope.selectedHojaRuta = 0;
                }

                function anterior() {
                    if ($scope.selectedHojaRuta === 0 && $scope.currentPage > 1) {
                        retrocederPagina();
                    } else {
                        $scope.selectedHojaRuta--;
                    }
                }

                function siguiente() {
                    if ($scope.selectedHojaRuta < $scope.currentPageHojaRuta.length - 1 ) {
                        $scope.selectedHojaRuta++;
                    } else {
                            avanzarPagina();
                    }
                }

                function retrocederPagina() {
                    if ($scope.currentPage > 1) {
                        $scope.selectPage($scope.currentPage - 1);
                        $scope.selectedHojaRuta = $scope.numPerPage - 1;
                    }
                }

                function avanzarPagina() {
                    if ($scope.currentPage < $scope.lastPage) {
                        $scope.selectPage($scope.currentPage + 1);
                        $scope.selectedHojaRuta = 0;
                    }
                }
            }
        ]
    );
