angular.module('focaAgendarVisita')
    .controller('focaAgendarVisitaController', [
        '$scope', 'focaAgendarVisitaService', '$location','$localStorage', '$timeout',
        '$uibModal', 'focaBotoneraLateralService', '$filter',
        'focaModalService', 'focaSeguimientoService',
        function($scope, focaAgendarVisitaService, $location, $localStorage, $timeout,
            $uibModal, focaBotoneraLateralService, $filter,
            focaModalService, focaSeguimientoService
        ) {

            config();
            init();

            function config() {
                $scope.focused = 0;
                $scope.rol = 1;
                $scope.visita = {};
                $scope.now = new Date();
            }

            function init() {
                $scope.botonera = focaAgendarVisitaService.getBotonera();
                $timeout(function() {
                    focaBotoneraLateralService.showSalir(false);
                    focaBotoneraLateralService.showPausar(true);
                    focaBotoneraLateralService.showGuardar(true, $scope.guardar);
                    focaBotoneraLateralService.addCustomButton('Salir', salir);
                });
    
                $timeout(function() {getLSVisita();});
            }

            $scope.seleccionarCliente = function() {
                var modalInstance = $uibModal.open(
                    {
                        ariaLabelledBy: 'Busqueda de Cliente',
                        templateUrl: 'foca-busqueda-cliente-modal.html',
                        controller: 'focaBusquedaClienteModalController',
                        resolve: {
                            vendedor: function() { return null; },
                            cobrador: function() { return null; }
                        },
                        size: 'lg'
                    }
                );
                modalInstance.result.then(
                    function(cliente) {
                        $scope.visita.cliente = cliente;
                        $scope.$broadcast('addCabecera', {
                            label: 'Cliente:',
                            valor: $filter('rellenarDigitos')(cliente.cod, 3) + ' - ' +
                                cliente.nom
                        });
                    }
                );
            };
            function setearVisita(visita){
                $scope.visita = visita;
                $scope.$broadcast('addCabecera', {
                    label: 'Cliente:',
                    valor: $filter('rellenarDigitos')(visita.cliente.cod, 3) + ' - ' +
                        visita.cliente.nom
                });
            }
            function getLSVisita(){
                var visita = JSON.parse($localStorage.visita || null);
                if (visita) {
                    setearVisita(visita);
                    delete $localStorage.visita;
                }
            }

            $scope.seleccionarVisitante = function() {
                var parametrosModal = {
                    query: '/vendedor-cobrador',
                    columnas: [
                        {
                            propiedad: 'NUM',
                            nombre: 'Codigo',
                            filtro: {
                                nombre: 'rellenarDigitos',
                                parametro: 3
                            }
                        },
                        {
                            propiedad: 'NOM',
                            nombre: 'Nombre'
                        }
                    ],
                    titulo:'Búsqueda de vendedores y cobradores',
                    size: 'md'
                };
                focaModalService.modal(parametrosModal).then(function(vendedorCobrador) {
                    if (vendedorCobrador.rol === 3) {
                        $uibModal.open(
                            {
                                ariaLabelledBy: 'Seleccionar tipo de visita',
                                templateUrl: 'modal-tipo-visita.html',
                                controller: 'focaModalTipoVisita',
                                resolve: {},
                                size: 'md'
                            }
                        )
                        .result
                        .then(function(res) {
                            $scope.rol = res;
                            $scope.visita.visitante = vendedorCobrador;
                            $scope.$broadcast('addCabecera', {
                                label: 'Vendedor:',
                                valor: $filter('rellenarDigitos')(vendedorCobrador.NUM, 3) + ' - ' +
                                    vendedorCobrador.NOM
                            });
                        });
                        
                    } else {
                        $scope.visita.visitante = vendedorCobrador;
                        $scope.$broadcast('addCabecera', {
                            label: 'Vendedor:',
                            valor: $filter('rellenarDigitos')(vendedorCobrador.NUM, 3) + ' - ' +
                                vendedorCobrador.NOM
                        });
                    }

                });
            };
            $scope.seleccionarObservaciones = function() {
                focaModalService
                    .prompt({
                        titulo: 'Ingrese observaciones',
                        value: $scope.visita.observacion,
                        textarea: true
                    })
                    .then(function(observacion) {
                        $scope.visita.observacion = observacion;
                    });
            };

            $scope.next = function(key) {
                if (key === 13) $scope.focused ++;
            };

            $scope.$watch('visita', function(newValue, oldValue){
                focaBotoneraLateralService.setPausarData({
                    label: 'visita',
                    val: newValue
                });                             
            });

            $scope.guardar = function() {
                var rol;
                if ($scope.visita.visitante.rol === 1) {
                    rol = 'Nota de pedido';
                } else if ($scope.visita.visitante.rol === 2) {
                    rol = 'Cobranza';
                } else {
                    rol = ($scope.rol === 1) ? 'Nota de pedido' : 'Cobranza';
                }

                focaAgendarVisitaService
                    .guardarVisita({
                        idVisitante: $scope.visita.visitante.NUM,
                        idCliente: $scope.visita.cliente.cod
                    })
                    .then(function(data) {
                        focaSeguimientoService.guardarPosicion(
                            rol,
                            data.data.id,
                            $scope.visita.observacion,
                            data.data.id
                        );
                    })
                    .then(function() {
                        $location.path('/');
                    });
            };
            function salir() {
                var confirmar = angular.equals($scope.visita, {});

                if (!confirmar) {
                    focaModalService.confirm(
                        '¿Está seguro de que desea salir? Se perderán todos los datos cargados.'
                    ).then(function(data) {
                        if (data) $location.path('/');
                    });
                } else {
                    $location.path('/');
                }
            }
        }
    ])
    .controller('focaModalTipoVisita', ['$uibModalInstance', '$scope',
        function($uibModalInstance, $scope) {
            $scope.cancel = function() {
                $uibModalInstance.dismiss();
            };

            $scope.select = function(val) {
                $uibModalInstance.close(val);
            };
        }
    ]);
