
exports.up = function(knex) {
    return knex.schema.createTable('nota_pedido', function(table) {
        table.increments();
        table.integer('bomba');
        table.integer('cotizacion');
        table.string('cuitCliente');
        table.string('domicilioStamp');
        table.integer('estado');
        table.dateTime('fechaCarga');
        table.integer('flete');
        table.integer('fob');
        table.decimal('kilometros', 12, 2);
        table.string('nombreCliente');
        table.integer('numeroNotaPedido');
        table.integer('responsabilidadIvaCliente');
        table.integer('sucursal');
        table.decimal('total', 12, 2);
        table.bigInteger('idCliente').unsigned();
        table.bigInteger('idCotizacion').unsigned();
        table.bigInteger('idDomicilio').unsigned();
        table.bigInteger('idPrecioCondicion').unsigned();
        table.bigInteger('idProveedor').unsigned();
        table.bigInteger('idRemito').unsigned();
        table.bigInteger('idVendedor').unsigned();
    }).createTable('precios_condiciones', function(table) {
        table.increments();
        table.boolean('activo');
        table.string('codigo');
        table.string('descripcion');
        table.string('nombre');
        table.date('vigencia');
        table.bigInteger('idListaPrecio').unsigned();
    }).createTable('plazo_pago', function(table) {
        table.increments();
        table.boolean('activo');
        table.integer('dias');
        table.integer('item');
        table.bigInteger('idPreciosCondiciones').unsigned();
    }).createTable('articulo_nota_pedido', function(table) {
        table.increments();
        table.decimal('cantidad', 12, 2);
        table.string('codigo');
        table.boolean('combustible');
        table.decimal('costoUnitario', 12, 2);
        table.string('descripcion');
        table.decimal('exentoUnitario', 12, 2);
        table.boolean('facturado');
        table.decimal('impuestoInternoUnitario', 12, 2);
        table.decimal('impuestoInterno1Unitario', 12, 2);
        table.decimal('impuestoInterno2Unitario', 12, 2);
        table.integer('item');
        table.decimal('ivaUnitario', 12, 2);
        table.decimal('ivaServicioUnitario', 12, 2);
        table.string('nombre');
        table.decimal('precio', 12, 4);
        table.decimal('precioLista', 12, 2);
        table.integer('sector');
        table.integer('rubro');
        table.decimal('tasaIva', 12, 2);
        table.bigInteger('idNotaPedido').unsigned();
    }).createTable('boton', function(table) {
        table.increments();
        table.string('accion');
        table.string('app');
        table.string('clase');
        table.string('texto');
    }).createTable('chofer', function(table) {
        table.increments();
        table.string('dni');
        table.string('nombre');
        table.string('telefono');
        table.bigInteger('idTransportista').unsigned();
    }).createTable('vehiculo', function(table) {
        table.increments();
        table.string('capacidad');
        table.string('cisternado');
        table.string('semi');
        table.string('tractor');
        table.bigInteger('idTransportista').unsigned();
        // TODO: Revisar si en los seeds no inserta por ser nombres de campo demasiado largos.
        // table.string('seguimientoSatelitalUrl');
        // table.string('seguimientoSatelitalUsuario');
        // table.string('seguimientoSatelitalClave');
    }).createTable('nota-pedido-plazo', function(table) {
        table.increments();
        table.integer('dias').unsigned();
        table.bigInteger('idNotaPedido').unsigned();
    }).createTable('seguimiento', function(table) {
        table.increments();
        table.string('actividad');
        table.integer('distancia');
        table.dateTime('fecha');
        table.string('latitud');
        table.string('longitud');
        table.string('observaciones');
        table.integer('orden');
        table.bigInteger('idUsuario').unsigned();
    }).createTable('nota-pedido-estado', function(table) {
        table.increments();
        table.integer('estado');
        table.dateTime('fecha');
        table.bigInteger('idNotaPedido').unsigned();
        table.integer('idVendedor').unsigned();
    }).createTable('configuracion_terminal', function(table) {
        table.increments();
        table.string('terminalKey');
        table.string('valor');
        table.string('variable');
    }).createTable('remito', function(table) {
        table.increments();
        table.boolean('anulado');
        table.integer('asiento');
        table.integer('bomba');
        table.decimal('carga', 12, 2);
        table.string('cuitCliente');
        table.integer('cuentaContable');
        table.integer('cuentaMadre');
        table.decimal('descuento', 12, 2);
        table.integer('destinoVenta');
        table.string('domicilioStamp');
        table.integer('estado');
        table.dateTime('fechaRemito');
        table.integer('flete');
        table.integer('fob');
        table.decimal('importeExento', 12, 2);
        table.decimal('importeImpuestoInterno', 12, 2);
        table.decimal('importeImpuestoInterno1', 12, 2);
        table.decimal('importeImpuestoInterno2', 12, 2);
        table.decimal('importeIva', 12, 2);
        table.decimal('importeIvaServicios', 12, 2);
        table.decimal('importeNeto', 12, 2);
        table.decimal('kilometros', 12, 2);
        table.integer('lugar');
        table.string('nombreCliente');
        table.integer('numeroLiquidoProducto');
        table.integer('numeroNotaPedido');
        table.integer('numeroRemito');
        table.integer('operacionTipo');
        table.decimal('percepcion', 12, 2);
        table.decimal('percepcionIva', 12, 2);
        table.integer('planilla');
        table.integer('sucursal');
        table.decimal('redondeo', 12, 2);
        table.integer('responsabilidadIvaCliente');
        table.decimal('total', 12, 2);
        table.bigInteger('idVendedor').unsigned();
        table.bigInteger('idProveedor').unsigned();
        table.bigInteger('idDomicilio').unsigned();
        table.bigInteger('idCotizacion').unsigned();
        table.bigInteger('idPrecioCondicion').unsigned();
        table.bigInteger('idHojaRuta').unsigned();
        table.bigInteger('idCliente').unsigned();
        table.string('e_hd');
        table.string('c_hd');
    }).createTable('articulo_remito', function(table) {
        table.increments();
        table.decimal('cantidad', 12, 2);
        table.string('codigo');
        table.boolean('combustible');
        table.decimal('costoUnitario', 12, 2);
        table.string('descripcion');
        table.decimal('exentoUnitario', 12, 2);
        table.boolean('facturado');
        table.integer('item');
        table.decimal('impuestoInternoUnitario', 12, 2);
        table.decimal('impuestoInterno1Unitario', 12, 2);
        table.decimal('impuestoInterno2Unitario', 12, 2);
        table.decimal('ivaServicioUnitario', 12, 2);
        table.decimal('ivaUnitario', 12, 2);
        table.string('nombre');
        table.decimal('precio', 12, 4);
        table.decimal('precioLista', 12, 2);
        table.integer('sector');
        table.integer('rubro');
        table.decimal('tasaIva', 12, 2);
        table.bigInteger('idRemito').unsigned();
    }).createTable('hoja_ruta', function(table) {
        table.increments();
        table.dateTime('fechaCreacion');
        table.bigInteger('numeroHojaRuta').unsigned();
        table.integer('sucursal').unsigned();
        table.decimal('tarifaFlete', 12, 2);
        table.bigInteger('idTransportista').unsigned();
        table.bigInteger('idChofer').unsigned();
        table.bigInteger('idVehiculo').unsigned();
    });
};

exports.down = function(knex) {
    return knex.schema
            .dropTable('nota_pedido')
            .dropTable('precios_condiciones')
            .dropTable('plazo_pago')
            .dropTable('articulo_nota_pedido')
            .dropTable('boton')
            .dropTable('chofer')
            .dropTable('vehiculo')
            .dropTable('nota-pedido-plazo')
            .dropTable('seguimiento')
            .dropTable('nota-pedido-estado')
            .dropTable('configuracion_terminal')
            .dropTable('remito')
            .dropTable('articulo_remito')
            .dropTable('hoja_ruta')
};
