
exports.up = function(knex) {
    return knex.schema
        .table('vehiculo', function(table) {
            table.string('codigo');
            table.dropColumn('cisternado');
        })
        .createTable('cisterna', function(table) {
            table.increments();
            table.string('codigo');
            table.decimal('capacidad', 12, 2);
            table.bigInteger('idVehiculo').unsigned();
            table.bigInteger('idUnidadMedida').unsigned();
            table.bigInteger('idCarga').unsigned();
        })
        .createTable('cisterna_carga', function(table) {
            table.increments();
            table.decimal('cantidad', 12, 2);
            table.bigInteger('codigoArticulo').unsigned();
            table.bigInteger('codigoSectorArticulo').unsigned();
        })
        .createTable('cisterna_movimiento', function(table) {
            table.increments();
            table.dateTime('fecha');
            table.decimal('cantidad', 12, 2);
            table.string('metodo');
            table.bigInteger('idCisternaCarga').unsigned();
        })
        .createTable('hoja_ruta_movimiento', function(table) {
            table.increments();
            table.string('reciboDescarga');
            table.bigInteger('idRemito').unsigned();
            table.bigInteger('idCisternaMovimiento').unsigned();
            table.bigInteger('idSeguimiento').unsigned();
        })
        .table('nota_pedido', function(table) {
            table.bigInteger('idSeguimiento').unsigned();
        })
        .table('hoja_ruta', function(table) {
            table.bigInteger('idSeguimiento').unsigned();
        })
};

exports.down = function(knex) {
    return knex.schema
        .table('vehiculo', function(table) {
            table.string('cisternado');
            table.dropColumn('codigo');
        })
        .table('nota_pedido', function(table) {
            table.dropColumn('idSeguimiento');
        })
        .table('hoja_ruta', function(table) {
            table.dropColumn('idSeguimiento');
        })
        .dropTable('cisterna')
        .dropTable('cisterna_carga')
        .dropTable('cisterna_movimiento')
        .dropTable('hoja_ruta_movimiento')
};
