
exports.up = function(knex) {
    return knex.schema
        .createTable('a_punto_descarga', function(table) {
            table.increments();
            table.bigInteger('id_cliente');
            table.bigInteger('id_da_config_0');
            table.string('descripcion');
            table.string('latitud');
            table.string('longitud');
            table.boolean('desactivado');
        })
        .table('CLIENTES', function(table) {
            table.boolean('ES_PROS');
        })
        .createTable('nota_pedido_punto_descarga', function(table) {
            table.increments();
            table.bigInteger('idPuntoDescarga').unsigned();
            table.bigInteger('idNotaPedido').unsigned();
            table.bigInteger('idProducto').unsigned();
            table.decimal('cantidad', 12, 2);
        });
};

exports.down = function(knex) {
    return knex.schema
        .dropTable('a_punto_descarga')
        .table('CLIENTES', function(table) {
            table.dropColumn('ES_PROS');
        })
        .dropTable('nota_pedido_punto_descarga');
};
