exports.up = function(knex) {
    return knex.schema.table('AVENDCLI', function(table) {
        table.string('domicilio');
        table.bigInteger('idLocalidad').unsigned();
        table.bigInteger('idProvincia').unsigned();
        table.integer('codigoPostal').unsigned();
        table.string('telefono');
        table.integer('dni');
        table.boolean('desactivado').notNullable().defaultTo(0);
        table.tinyint('turno').notNullable().defaultTo(0);
        //Puede ser 1=vendedor, 2=cobrador, 3=ambos
        table.integer('rol').notNullable().defaultTo(1);
        table.bigInteger('idLogin').unsigned();
        table.decimal('comisionVendedor', 12, 2).notNullable().defaultTo(0);
        table.decimal('comisionCobrador', 12, 2).notNullable().defaultTo(0);
    }).raw("ALTER TABLE AVENDCLI ADD id INT IDENTITY(1,1)")
};

exports.down = function(knex, Promise) {
    // PARA HACER FUNCIONAR ESTE ROLLBACK HAY QUE BORRAR MANUALMENTE LAS CONSTRAINS QUE SE
    // CREAN PARA SER VALORES POR DEFECTO
    return knex.schema.table('AVENDCLI', function(table) {
        table.dropColumns(
            'id',
            'domicilio',
            'idLocalidad',
            'idProvincia',
            'codigoPostal',
            'telefono',
            'dni',
            'idLogin',
            'desactivado',
            'turno',
            'rol',
            'comisionVendedor',
            'comisionCobrador'
        );
    })
};
