exports.up = function(knex, Promise) {
    return knex.schema
        .table('articulo_nota_pedido', function(table) {
            table.dropColumns(
                'costoUnitario', 'exentoUnitario', 'impuestoInternoUnitario', 
                'impuestoInterno1Unitario', 'impuestoInterno2Unitario', 'ivaServicioUnitario',
                'ivaUnitario', 'tasaIva');
        }).table('articulo_nota_pedido', function(table) {
            table.decimal('netoUnitario', 14, 4);
            table.decimal('costoUnitario', 14, 4);
            table.decimal('exentoUnitario', 14, 4);
            table.decimal('impuestoInternoUnitario', 14, 4);
            table.decimal('impuestoInterno1Unitario', 14, 4);
            table.decimal('impuestoInterno2Unitario', 14, 4);
            table.decimal('ivaServicioUnitario', 14, 4);
            table.decimal('ivaUnitario', 14, 4);
            table.decimal('tasaIva', 14, 4);
        }).table('articulo_remito', function(table) {
            table.dropColumns(
                'costoUnitario', 'exentoUnitario', 'impuestoInternoUnitario', 
                'impuestoInterno1Unitario', 'impuestoInterno2Unitario', 'ivaServicioUnitario',
                'ivaUnitario', 'tasaIva');
        }).table('articulo_remito', function(table) {
            table.decimal('netoUnitario', 14, 4);
            table.decimal('costoUnitario', 14, 4);
            table.decimal('exentoUnitario', 14, 4);
            table.decimal('impuestoInternoUnitario', 14, 4);
            table.decimal('impuestoInterno1Unitario', 14, 4);
            table.decimal('impuestoInterno2Unitario', 14, 4);
            table.decimal('ivaServicioUnitario', 14, 4);
            table.decimal('ivaUnitario', 14, 4);
            table.decimal('tasaIva', 14, 4);
        })
};

exports.down = function(knex, Promise) {

    //PARA HACER FUNCIONAR ESTE ROLLBACK HAY QUE ELIMINAR MANUALMENTE LAS COLUMNAS
    return knex.schema
        .table('articulo_nota_pedido', function(table) {
            table.dropColumns('netoUnitario', 'costoUnitario', 'exentoUnitario', 
                'impuestoInternoUnitario', 'impuestoInterno1Unitario', 'impuestoInterno2Unitario',
                'ivaServicioUnitario', 'ivaUnitario', 'tasaIva');
            table.decimal('costoUnitario', 12, 2);
            table.decimal('exentoUnitario', 12, 2);
            table.decimal('impuestoInternoUnitario', 12, 2);
            table.decimal('impuestoInterno1Unitario', 12, 2);
            table.decimal('impuestoInterno2Unitario', 12, 2);
            table.decimal('ivaServicioUnitario', 12, 2);
            table.decimal('ivaUnitario', 12, 2);
            table.decimal('tasaIva', 12, 2);
        }).table('articulo_remito', function(table) {
            table.dropColumns('netoUnitario', 'costoUnitario', 'exentoUnitario', 
                'impuestoInternoUnitario', 'impuestoInterno1Unitario', 'impuestoInterno2Unitario',
                'ivaServicioUnitario', 'ivaUnitario', 'tasaIva');
            table.decimal('costoUnitario', 12, 2);
            table.decimal('exentoUnitario', 12, 2);
            table.decimal('impuestoInternoUnitario', 12, 2);
            table.decimal('impuestoInterno1Unitario', 12, 2);
            table.decimal('impuestoInterno2Unitario', 12, 2);
            table.decimal('ivaServicioUnitario', 12, 2);
            table.decimal('ivaUnitario', 12, 2);
            table.decimal('tasaIva', 12, 2);
        })
};
