angular.module('focaBusquedaProductos')
    .controller('modalBusquedaProductosCtrl',
        [
            '$timeout',
            '$filter',
            '$scope',
            '$uibModalInstance',
            'parametroProducto',
            'focaBusquedaProductosService',
            function ($timeout, $filter, $scope, $uibModalInstance, parametroProducto,
                focaBusquedaProductosService
            ) {

                $scope.simbolo = parametroProducto.simbolo;
                $scope.filters = '';
                $scope.listaProductos = [];
                $scope.todosProductos = [];
                $scope.primerBusqueda = false;
                $scope.searchLoading = false;
                $scope.soloMostrar = parametroProducto.soloMostrar;
                $scope.useAllProducts = false;
                //#region pagination variables
                $scope.numPerPage = 10;
                $scope.currentPage = 1;
                $scope.filteredProductos = [];
                $scope.currentPageProductos = [];
                $scope.selectedProducto = -1;
                //#endregion

                //METODOS
                $scope.busquedaPress = function (key) {
                    if (key === 13) {
                        $scope.searchLoading = true;
                        focaBusquedaProductosService
                            .getProductosByIdLista(parseInt(parametroProducto.idLista), $scope.filters)
                            .then(function (data) {
                                llenarDatos(data);
                                focaBusquedaProductosService.getProductos()
                                    .then(fillAllProductos);
                            })
                            .catch(function (e) { console.log(e) });
                    }
                };
                function llenarDatos(res) {
                    for (var i = 0; i < res.data.length; i++) {
                        res.data[i].precio = res.data[i].precio / parametroProducto.cotizacion;
                    }
                    $scope.searchLoading = false;
                    $scope.primerBusqueda = true;
                    $scope.listaProductos = res.data;
                    $scope.search(true);
                    primera();
                };
                function fillAllProductos(res) {
                    for (var i = 0; i < res.data.length; i++) {
                        var producto = $scope.listaProductos.filter(function (producto) {
                            return producto.id == res.data[i].id;
                        })[0];

                        if (producto) {
                            res.data[i].precio = producto.precio;
                        }
                    }
                    $scope.searchLoading = false;
                    $scope.primerBusqueda = true;
                    $scope.todosProductos = res.data;
                    $scope.search(true);
                    primera();
                };
                $scope.changeProductsData = function () {
                    $scope.useAllProducts = !$scope.useAllProducts;
                    $scope.search(false);
                    primera();
                };
                $scope.search = function (pressed) {
                    if ($scope.listaProductos.length > 0 || $scope.todosProductos.length > 0) {
                        $scope.filteredProductos = $filter('filter')(
                            ($scope.useAllProducts ? $scope.todosProductos : $scope.listaProductos),
                            { $: $scope.filters }
                        );

                        $scope.lastPage = Math.ceil(
                            $scope.filteredProductos.length / $scope.numPerPage
                        );

                        $scope.resetPage();
                    } else if (pressed) {
                        $timeout(function () {
                            angular.element('#search')[0].focus();
                            $scope.filters = '';
                        });
                    }
                };
                $scope.resetPage = function () {
                    $scope.currentPage = 1;
                    $scope.selectPage(1);
                };
                $scope.selectPage = function (page) {
                    var start = (page - 1) * $scope.numPerPage;
                    var end = start + $scope.numPerPage;
                    $scope.paginas = [];
                    $scope.paginas = calcularPages(page);
                    $scope.currentPageProductos = $scope.filteredProductos.slice(start, end);
                    $scope.currentPage = page;
                };
                $scope.select = function (producto) {
                    $uibModalInstance.close(producto);
                };
                $scope.cancel = function () {
                    $uibModalInstance.dismiss('cancel');
                };
                $scope.busquedaDown = function (key) {
                    if (key === 40) {
                        primera(key);
                    }
                };
                $scope.itemProducto = function (key) {
                    if (key === 38) {
                        anterior(key);
                    }

                    if (key === 40) {
                        siguiente(key);
                    }

                    if (key === 37) {
                        retrocederPagina();
                    }

                    if (key === 39) {
                        avanzarPagina();
                    }
                };

                //#region Paginador
                function calcularPages(paginaActual) {
                    var paginas = [];
                    paginas.push(paginaActual);

                    if (paginaActual - 1 > 1) {

                        paginas.unshift(paginaActual - 1);
                        if (paginaActual - 2 > 1) {
                            paginas.unshift(paginaActual - 2);
                        }
                    }

                    if (paginaActual + 1 < $scope.lastPage) {
                        paginas.push(paginaActual + 1);
                        if (paginaActual + 2 < $scope.lastPage) {
                            paginas.push(paginaActual + 2);
                        }
                    }

                    if (paginaActual !== 1) {
                        paginas.unshift(1);
                    }

                    if (paginaActual !== $scope.lastPage) {
                        paginas.push($scope.lastPage);
                    }

                    return paginas;
                };
                function primera() {
                    $scope.selectedProducto = 0;
                };
                function anterior() {
                    if ($scope.selectedProducto === 0 && $scope.currentPage > 1) {
                        retrocederPagina();
                    } else {
                        $scope.selectedProducto--;
                    }
                };
                function siguiente() {
                    if ($scope.selectedProducto < $scope.currentPageProductos.length - 1) {
                        $scope.selectedProducto++;
                    } else {
                        avanzarPagina();
                    }
                };
                function retrocederPagina() {
                    if ($scope.currentPage > 1) {
                        $scope.selectPage($scope.currentPage - 1);
                        $scope.selectedProducto = $scope.numPerPage - 1;
                    }
                };
                function avanzarPagina() {
                    if ($scope.currentPage < $scope.lastPage) {
                        $scope.selectPage($scope.currentPage + 1);
                        $scope.selectedProducto = 0;
                    }
                };
                //#endregion

                $scope.busquedaPress(13);
            }
        ]
    );
