angular.module('appWrapperFacturador')
    .controller('appWrapperFacturadorController', [
        '$scope',
        '$rootScope',
        '$timeout',
        '$uibModalStack',
        function ($scope, $rootScope, $timeout, $uibModalStack) {
            $scope.usarTeclado = false;
            $rootScope.$broadcast('usarTeclado', false);
            $scope.mostrarTeclado = false;
            //Envía broadcast para avisar que el teclado está en funcionamiento o no
            //para su uso cambiar ng-click del boton por esta función
            $scope.cambioUsoTeclado = function () {
                if ($scope.usarTeclado) {
                    $scope.usarTeclado = false;
                    $rootScope.$broadcast('usarTeclado', false);
                    return;
                }
                $scope.usarTeclado = true;
                $rootScope.$broadcast('usarTeclado', true);
            };

            $rootScope.$on('focus', function () {
                if (!$scope.usarTeclado) {
                    return;
                }
                $scope.mostrarTeclado = true;
                $timeout.cancel($scope.timeout);
                if (!$scope.$$phase) {
                    $scope.$apply();
                }
            });
            $rootScope.$on('blur', function () {
                $scope.timeout = $timeout(function () {
                    $scope.mostrarTeclado = false;
                    if (!$scope.$$phase) {
                        $scope.$apply();
                    }
                }, 150);
            });

            // Close all modals
            $rootScope.$on('$locationChangeSuccess', function () {
                $uibModalStack.dismissAll('close');
            });
        }
    ]);
