angular.module('focaLogin')
    .controller('focaLoginController', [
        '$scope', 'focaLoginService', '$location', '$cookies', 'focaModalService', 'md5', 'APP',
        function($scope, focaLoginService, $location, $cookies, focaModalService, md5, APP) {
            $scope.paso = 1;
            $scope.enviar = function() {
                angular.element('#password').blur();
                focaLoginService.login({
                    idUsuario: $scope.usuario.idUsuario,
                    clave: APP != 'facturador' ? md5.createHash($scope.usuario.clave) :
                        $scope.usuario.clave
                }).then(function(datos) {
                    if (datos.data.chofer && datos.data.chofer.id) {
                        $cookies.put('chofer', datos.data.chofer.id);
                        $cookies.put('nombreUsuario', datos.data.chofer.nombre);
                    } else if (datos.data.vendedorCobrador && datos.data.vendedorCobrador.id) {
                        $cookies.put('vendedorCobrador', datos.data.vendedorCobrador.id);
                        $cookies.put('nombreUsuario', datos.data.vendedorCobrador.NOM);
                    } else if (datos.data.vendedorPlaya) {
                        $cookies.put('vendedorPlaya', datos.data.vendedorPlaya.CodVen);
                        $cookies.put('nombreUsuario', datos.data.vendedorPlaya.NomVen.trim());
                    } else {
                        focaModalService.alert('Existe un error con el usuario ingresado');
                        return;
                    }

                    console.info(datos.data);
                    $cookies.put('token', datos.data.token);
                    $location.path('/');
                    $scope.$emit('blur');
                }, function(error) {
                    if (error.status === 401) {
                        focaModalService
                            .alert('El usuario o la contraseña han sido mal introducidos');
                    }

                    if(error.status === -1) {
                        focaModalService.alert('Sin servicio');
                        return;
                    }
                });
            };
            $scope.irPaso = function(numeroPaso) {
                $scope.paso = numeroPaso;
            };
        }
    ])
    .controller('focaLogoutController', [
        '$cookies', '$location',
        function($cookies, $location) {
            $cookies.remove('chofer');
            $cookies.remove('vendedorCobrador');
            $cookies.remove('vendedorPlaya');
            $cookies.remove('nombreUsuario');
            $cookies.remove('token');
            //Cierra ventana
            window.open('', '_self', ''); //bug fix
            window.close();
            $location.path('/login');
        }
    ]);
