const templateCache = require('gulp-angular-templatecache');
const concat        = require('gulp-concat');
const clean         = require('gulp-clean');
const htmlmin       = require('gulp-htmlmin');
const rename        = require('gulp-rename');
const uglify        = require('gulp-uglify-es').default;
const gulp          = require('gulp');
const pump          = require('pump');
const jshint        = require('gulp-jshint');
const replace       = require('gulp-replace');
const connect       = require('gulp-connect');
const header        = require('gulp-header');
const footer        = require('gulp-footer');

var paths = {
    srcJS: 'src/js/*.js',
    srcViews: 'src/views/*.html',
    specs: 'spec/*.js',
    tmp:   'tmp',
    dist:  'dist/'
};

gulp.task('templates', function() {
    return pump(
        [
            gulp.src(paths.srcViews),
            htmlmin(),
            templateCache('views.js', {
                module: 'focaAbmPreciosCondiciones',
                root: ''
            }),
            gulp.dest(paths.tmp)
        ]
    );
});

gulp.task('uglify', ['templates', 'uglify-spec'], function() {
    return pump(
        [
            gulp.src([
                paths.srcJS,
                'tmp/views.js'
            ]),
            concat('foca-abm-precios-condiciones.js'),
            replace('src/views/', ''),
            gulp.dest(paths.tmp),
            rename('foca-abm-precios-condiciones.min.js'),
            uglify(),
            gulp.dest(paths.dist)
        ]
    );
});

gulp.task('uglify-spec', function() {
    return pump([
        gulp.src(paths.specs),
        concat('foca-abm-precios-condiciones.spec.js'),
        replace("src/views/", ''),
        header("describe('Módulo foca-abm-precios-condiciones', function() { \n"),
        footer("});"),
        gulp.dest(paths.dist)
    ]);
});

gulp.task('clean', function() {
    return gulp.src(['tmp', 'dist'], {read: false})
    .pipe(clean());
});

gulp.task('pre-commit', function() {
    return pump(
        [
            gulp.src([paths.srcJS, paths.specs]),
            jshint('.jshintrc'),
            jshint.reporter('default'),
            jshint.reporter('fail')
        ]
    );
});

gulp.task('clean-post-install', function() {
    return gulp.src(['src', 'tmp', '.jshintrc','readme.md', '.gitignore', 'gulpfile.js',
                     'index.html', 'spec', 'test.html'], {read: false})
    .pipe(clean());
});

gulp.task('webserver', function() {
    pump [
        connect.server({port: 3000})
    ]
});

gulp.task('default', ['webserver']);
