describe('Controladores abm precios condiciones', function() {

    var $controller;
    var timeout;

    beforeEach(function() {
        module('focaAbmPreciosCondiciones');
        inject(function(_$controller_) {
            $controller = _$controller_;
        });
    });

    beforeEach(function() {
        inject(function($timeout) {
            timeout = $timeout;
        });
    });

    describe('Controlador focaAbmPreciosCondiciones', function() {

        it('Existe el controlador', function() {
            //act
            var controlador = $controller('focaAbmPreciosCondicionesController', {
                $scope: {},
                focaAbmPreciosCondicionesService: {},
                $location: {},
                focaModalService: {},
                $localStorage: {},
                focaBotoneraLateralService: {},
                $timeout: timeout
            });

            //assert
            expect(typeof controlador).toEqual('object');
        });

        it('$scope.editar lleva a la ruta correcta', function() {
            inject(function($location) {
                //arrange
                var scope = {};
                var paramFake = 1;
                $controller('focaAbmPreciosCondicionesController', {
                    $scope: scope,
                    focaAbmPreciosCondicionesService: {},
                    $location: $location,
                    $localStorage: {},
                    focaModalService: {},
                    focaBotoneraLateralService: {},
                    $timeout: timeout
                });


                //act
                scope.editar(paramFake);

                //assert
                expect($location.url()).toEqual('/precio-condicion/' + paramFake);
            });
        });

        it('$scope.solicitarConfirmacion levanta modal confirm', function() {
            //arrange
            var scope = {};
            var paramFake = 1;
            var focaModalService = {
                confirm: function() { }
            };
            $controller('focaAbmPreciosCondicionesController', {
                $scope: scope,
                focaAbmPreciosCondicionesService: {},
                $location: {},
                $localStorage: {},
                focaModalService: focaModalService,
                focaBotoneraLateralService: {},
                $timeout: timeout
            });

            //act
            spyOn(focaModalService, 'confirm').and.returnValue({ then: function() { }});
            scope.solicitarConfirmacion(paramFake);

            //assert
            expect(focaModalService.confirm).toHaveBeenCalled();
        });

        it('$scope.solicitarConfirmacion elimina al confirmar ok', function(done) {
            //arrange
            var scope = {};
            var paramFake = 1;
            var focaModalService = {
                confirm: function() { }
            };
            var focaAbmPreciosCondicionesService = {
                borrarPrecioCondicion: function() { }
            };
            $controller('focaAbmPreciosCondicionesController', {
                $scope: scope,
                focaAbmPreciosCondicionesService: focaAbmPreciosCondicionesService,
                $location: {},
                $localStorage: {},
                focaModalService: focaModalService,
                focaBotoneraLateralService: {},
                $timeout: timeout
            });
            var promesaConfirm = Promise.resolve(true);
            scope.preciosCondiciones = [];

            //act
            spyOn(focaModalService, 'confirm').and.returnValue(promesaConfirm);
            spyOn(focaAbmPreciosCondicionesService, 'borrarPrecioCondicion');
            scope.solicitarConfirmacion(paramFake);

            //assert
            promesaConfirm.then(function() {
                expect(focaAbmPreciosCondicionesService.borrarPrecioCondicion).toHaveBeenCalled();
                done();
            });
        });

        it('$scope.buscar llama a obtenerPreciosCondiciones', function() {
            //arrange
            var scope = {};
            var focaAbmPreciosCondicionesService = {
                obtenerPreciosCondiciones: function() { }
            };
            $controller('focaAbmPreciosCondicionesController', {
                $scope: scope,
                focaAbmPreciosCondicionesService: focaAbmPreciosCondicionesService,
                $location: {},
                $localStorage: {},
                focaModalService: {},
                focaBotoneraLateralService: {},
                $timeout: timeout
            });

            //act
            spyOn(focaAbmPreciosCondicionesService, 'obtenerPreciosCondiciones')
                .and.returnValue({ then: function() { }});
            scope.buscar(13);

            //assert
            expect(focaAbmPreciosCondicionesService.obtenerPreciosCondiciones).toHaveBeenCalled();
        });
    });

    describe('Controlador focaAbmPrecioCondicionController', function() {

        it('Existe el controlador focaAbmPrecioCondicionController', function() {
            //act
            var controlador = $controller('focaAbmPrecioCondicionController', {
                $scope: {
                    $watch: function(){}
                },
                focaAbmPreciosCondicionesService: {
                    obtenerPrecioCondicion: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                focaBotoneraLateralService: {},
                $routeParams: {},
                $location: {},
                focaModalService: {},
                $timeout: timeout,
                $uibModal: {},
                $localStorage: {},
                $window: {}
            });

            //assert
            expect(typeof controlador).toEqual('object');
        });

        it('La funcion $scope.cancelar lleva a la ruta correcta', function() {
            inject(function($location) {
                //arrange
                var scope = {
                    $watch: function() {},
                    salir: function() {},
                    formPrecioCondicion: ''
                };
                $controller('focaAbmPrecioCondicionController', {
                    $scope: scope,
                    focaAbmPreciosCondicionesService: {
                        obtenerPrecioCondicion: function() {
                            return {
                                then: function() { }
                            };
                        }
                    },
                    focaBotoneraLateralService: {},
                    $routeParams: {},
                    $location: $location,
                    $localStorage: {},
                    focaModalService: {},
                    $timeout: timeout,
                    $uibModal: {},
                    $window: {}
                });

                //act
                scope.salir();

                //assert
                expect($location.url()).toEqual('/precio-condicion');
            });
        });

        it('La funcion $scope.guardar llama a servicio.guardarPrecioCondicion', function() {
            inject(function($location) {
                //arrange
                var scope = {
                    $watch: function() { }
                };
                var focaAbmPreciosCondicionesService = {
                    obtenerPrecioCondicion: function() {
                        return {
                            then: function() { }
                        };
                    },
                    guardarPrecioCondicion: function() { }
                };
                var window = {
                    location: {
                        assign: function() { }
                    }
                };
                $controller('focaAbmPrecioCondicionController', {
                    $scope: scope,
                    focaAbmPreciosCondicionesService: focaAbmPreciosCondicionesService,
                    focaBotoneraLateralService: {},
                    $routeParams: {},
                    $location: $location,
                    focaModalService: { 
                        alert: function() {}
                    },
                    $timeout: timeout,
                    $uibModal: {},
                    $localStorage: {},
                    $window: window
                });
                var promesaGuardarPrecioCondicion = Promise.resolve(true);
                scope.precioCondicion = {
                    listaPrecio: {},
                    nombre: true,
                    descripcion: true,
                    idListaPrecio: true
                };

                //act
                //spyOn(window, 'location').and.returnValue({ assign: function() {} });
                spyOn(focaAbmPreciosCondicionesService, 'guardarPrecioCondicion')
                    .and.returnValue(promesaGuardarPrecioCondicion);
                scope.guardar();

                //assert
                expect(focaAbmPreciosCondicionesService.guardarPrecioCondicion).toHaveBeenCalled();
            });
        });

        it('La funcion $scope.solicitarConfirmacionPlazoPago levanta modal confirm', function() {
            //act
            var scope = {
                $watch: function() {}
            };
            var focaModalService = {
                confirm: function() { }
            };
            $controller('focaAbmPrecioCondicionController', {
                $scope: scope,
                focaAbmPreciosCondicionesService: {
                    obtenerPrecioCondicion: function() {
                        return {
                            then:function() { }
                        };
                    }
                },
                focaBotoneraLateralService: {},
                $routeParams: {},
                $location: {},
                focaModalService: focaModalService,
                $timeout: timeout,
                $uibModal: {},
                $localStorage: {},
                $window: {}
            });

            //act
            spyOn(focaModalService, 'confirm')
                .and.returnValue({ then: function() {} });
            scope.solicitarConfirmacionPlazoPago({ data: 'test' });

            //assert
            expect(focaModalService.confirm).toHaveBeenCalled();
        });

        it('La funcion $scope.solicitarConfirmacionPlazoPago borra al dar ok', function(done) {
            //act
            var scope = {
                $watch: function() { }
            };
            var focaModalService = {
                confirm: function() { }
            };
            var focaAbmPreciosCondicionesService = {
                obtenerPrecioCondicion: function() {
                    return {
                        then:function() { }
                    };
                },
                borrarPlazoPago: function() { }
            };
            $controller('focaAbmPrecioCondicionController', {
                $scope: scope,
                focaAbmPreciosCondicionesService: focaAbmPreciosCondicionesService,
                focaBotoneraLateralService: {},
                $routeParams: {},
                $location: {},
                focaModalService: focaModalService,
                $timeout: timeout,
                $localStorage: {},
                $uibModal: {},
                $window: {}
            });
            var promesaConfirm = Promise.resolve(true);
            scope.precioCondicion = {
                plazos: []
            };

            //act
            spyOn(focaModalService, 'confirm').and.returnValue(promesaConfirm);
            spyOn(focaAbmPreciosCondicionesService, 'borrarPlazoPago');
            scope.solicitarConfirmacionPlazoPago({ data: 'test' });

            //assert
            promesaConfirm.then(function() {
                expect(focaAbmPreciosCondicionesService.borrarPlazoPago).toHaveBeenCalled();
                done();
            });
        });

        it('La funcion $scope.seleccionarListaPrecio levanta modal', function() {
            //arrange
            var scope = {
                $watch: function() {}
            };
            var uibModal = {
                open: function() { }
            };
            var focaAbmPreciosCondicionesService = {
                obtenerPrecioCondicion: function() {
                    return {
                        then:function() { }
                    };
                }
            };
            $controller('focaAbmPrecioCondicionController', {
                $scope: scope,
                focaAbmPreciosCondicionesService: focaAbmPreciosCondicionesService,
                focaBotoneraLateralService: {},
                $routeParams: {},
                $location: {},
                focaModalService: {},
                $timeout: timeout,
                $uibModal: uibModal,
                $localStorage: {},
                $window: {}
            });

            //act
            spyOn(uibModal, 'open').and.returnValue({ result: { then: function() { } } });
            scope.seleccionarListaPrecio(13);

            //assert
            expect(uibModal.open).toHaveBeenCalled();
        });

        it('La funcion $scope.verProductosListaPrecio levanta modal', function() {
            //arrange
            var scope = {
                $watch: function() {}
            };
            var uibModal = {
                open: function() { }
            };
            var focaAbmPreciosCondicionesService = {
                obtenerPrecioCondicion: function() {
                    return {
                        then:function() { }
                    };
                }
            };
            $controller('focaAbmPrecioCondicionController', {
                $scope: scope,
                focaAbmPreciosCondicionesService: focaAbmPreciosCondicionesService,
                focaBotoneraLateralService: {},
                $routeParams: {},
                $location: {},
                focaModalService: {},
                $timeout: timeout,
                $uibModal: uibModal,
                $localStorage: {},
                $window: {}
            });
            scope.precioCondicion = {
                listaPrecio: {}
            };
            //act
            spyOn(uibModal, 'open');
            scope.verProductosListaPrecio();

            //assert
            expect(uibModal.open).toHaveBeenCalled();
        });

        it('la función next suma uno a $scope.focused', function() {
            //arrange
            var scope = {
                $watch: function() {}
            };
            var focaAbmPreciosCondicionesService = {
                obtenerPrecioCondicion: function() {
                    return {
                        then:function() { }
                    };
                }
            };
            $controller('focaAbmPrecioCondicionController', {
                $scope: scope,
                focaAbmPreciosCondicionesService: focaAbmPreciosCondicionesService,
                focaBotoneraLateralService: {},
                $routeParams: {},
                $location: {},
                focaModalService: {},
                $timeout: timeout,
                $uibModal: {},
                $localStorage: {},
                $window: {}
            });

            //act
            var esperado = scope.focused + 1;
            scope.next(13);

            //assert
            expect(scope.focused).toEqual(esperado);
        });
    });
});
