describe('Servicios abm precios condiciones', function() {

    var httpBackend;

    beforeEach(function() {
        module('focaAbmPreciosCondiciones');

        inject(module(function($provide) {
            $provide.value('API_ENDPOINT', {
                URL: 'localhost'
            });
        }));
    });

    describe('servicio focaAbmPreciosCondicionesService', function() {

        var servicio;

        beforeEach(function() {
            inject(function(focaAbmPreciosCondicionesService, $httpBackend) {
                servicio = focaAbmPreciosCondicionesService;
                httpBackend = $httpBackend;
            });
        });

        it('existe el servicio focaAbmPreciosCondicionesService', function() {
            //assert
            expect(typeof servicio).toEqual('object');
        });

        it('la función obtenerPreciosCondiciones llama ruta correcta', function() {
            //arrange
            var responseFake = { data: 'test'};
            var result;
            var bodyFake = 1;
            httpBackend.expectPOST('localhost/precios-condiciones', { nombre: bodyFake })
                .respond(responseFake);

            //act
            servicio.obtenerPreciosCondiciones(bodyFake).then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(responseFake);
        });

        it('la función obtenerPrecioCondicion llama ruta correcta', function() {
            //arrange
            var responseFake = { data: 'test'};
            var result;
            var paramFake = 1;
            httpBackend.expectGET('localhost/precio-condicion/' + paramFake)
                .respond(responseFake);

            //act
            servicio.obtenerPrecioCondicion(paramFake).then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(responseFake);
        });

        it('la función guardarPrecioCondicion llama ruta correcta', function() {
            //arrange
            var responseFake = { data: 'test'};
            var result;
            var bodyFake = 1;
            httpBackend.expectPOST('localhost/precio-condicion', { precioCondicion: bodyFake })
                .respond(responseFake);

            //act
            servicio.guardarPrecioCondicion(bodyFake).then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(responseFake);
        });

        it('la función borrarPrecioCondicion llama ruta correcta', function() {
            //arrange
            var responseFake = { data: 'test'};
            var result;
            var paramFake = 1;
            httpBackend.expectDELETE('localhost/precio-condicion/' + paramFake)
                .respond(responseFake);

            //act
            servicio.borrarPrecioCondicion(paramFake).then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(responseFake);
        });

        it('la función obtenerPlazoPago llama ruta correcta', function() {
            //arrange
            var responseFake = { data: 'test'};
            var result;
            var paramFake = 1;
            httpBackend.expectGET('localhost/plazo-pago/precio-condicion/' + paramFake)
                .respond(responseFake);

            //act
            servicio.obtenerPlazoPago(paramFake).then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(responseFake);
        });

        it('la función borrarPlazoPago llama ruta correcta', function() {
            //arrange
            var responseFake = { data: 'test'};
            var result;
            var paramFake = 1;
            httpBackend.expectDELETE('localhost/plazo-pago/' + paramFake)
                .respond(responseFake);

            //act
            servicio.borrarPlazoPago(paramFake).then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(responseFake);
        });

        it('la función guardarPlazosPago llama ruta correcta', function() {
            //arrange
            var responseFake = { data: 'test'};
            var result;
            var bodyFake = 1;
            httpBackend.expectPOST('localhost/plazos-pago', { plazosPago: bodyFake})
                .respond(responseFake);

            //act
            servicio.guardarPlazosPago(bodyFake).then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(responseFake);
        });
    });
});
