angular.module('focaAbmPreciosCondiciones')
    .controller('focaAbmPreciosCondicionesController', [
        '$scope', 'focaAbmPreciosCondicionesService', '$location',
        'focaModalService', 'focaBotoneraLateralService', '$timeout', '$localStorage',
        function($scope, focaAbmPreciosCondicionesService, $location,
            focaModalService, focaBotoneraLateralService, $timeout, $localStorage) {

            $scope.focusSearch = false;
            $scope.filters = '';
            $scope.now = new Date();
            $timeout(function() {
                focaBotoneraLateralService.showSalir(true);
                focaBotoneraLateralService.showPausar(false);
                focaBotoneraLateralService.showCancelar(false);
                focaBotoneraLateralService.showGuardar(false);

                $scope.focusSearch = true;
            });

            $scope.filters = '';
            $scope.now = new Date();
            $scope.editar = function(id) {
                $location.path('/precio-condicion/' + id);
            };
            $scope.solicitarConfirmacion = function(precioCondicion) {
                focaModalService.confirm('¿Está seguro que desea borrar el precio condición' +
                    precioCondicion.codigo + ' ' + precioCondicion.nombre + ' ?').then(
                        function(data) {
                            if (data) {
                                focaAbmPreciosCondicionesService
                                    .borrarPrecioCondicion(precioCondicion.id);
                                $scope.preciosCondiciones.splice(
                                    $scope.preciosCondiciones.indexOf(precioCondicion), 1
                                );
                            }
                        }
                    );
            };

            $scope.buscar = function(key) {
                if(key === 13){
                    focaAbmPreciosCondicionesService
                        .obtenerPreciosCondiciones($scope.filters)
                        .then(function(datos) {
                            $scope.preciosCondiciones = datos.data;
                            $scope.preciosCondiciones.forEach(function(precioCondicion) {
                                precioCondicion.plazoPago.sort(function(a, b) { 
                                    return a.dias- b.dias;
                                });
                            });
                        });
                }
            };

            if ($localStorage.precioCondicion) {
                var precioCondicion = JSON.parse($localStorage.precioCondicion);
                if (!precioCondicion.id) { precioCondicion.id = 0; }
                $location.path('/precio-condicion/' + precioCondicion.id);
            }
        }
    ])
    .controller('focaAbmPrecioCondicionController', [
        '$scope', 'focaAbmPreciosCondicionesService', 'focaBotoneraLateralService',
        '$routeParams', '$location', 'focaModalService', '$timeout', '$uibModal', '$window', '$localStorage', '$filter',
        function(
            $scope, focaAbmPreciosCondicionesService, focaBotoneraLateralService,
            $routeParams, $location, focaModalService, $timeout, $uibModal, $window, $localStorage, $filter) {
            $scope.focused = 1;
            $scope.plazosAEliminar = [];
            $scope.mostrarPlazos = $routeParams.id > 0;
            $scope.now = new Date();
            $scope.listaPrecioLabel = '';
            $scope.precioCondicion = {
                id: 0,
                codigo: '',
                nombre: '',
                descripcion: '',
                idListaPrecio: 0,
                vigencia: new Date()
            };
            focaAbmPreciosCondicionesService.obtenerPrecioCondicion($routeParams.id)
                .then(function(datos) {
                    if (datos.data.id) {
                        $scope.precioCondicion = datos.data;
                        $scope.listaPrecioLabel = datos.data.listaPrecio.ID.trim() +
                            ' - ' + datos.data.listaPrecio.DES;
                        $scope.$broadcast('addCabecera', {
                            label: 'Precio y condición:',
                            valor: datos.data.nombre
                        });
                        focaAbmPreciosCondicionesService.obtenerPlazoPago(datos.data.id)
                            .then(function(datos) {
                                $scope.precioCondicion.plazos = datos.data;
                                $scope.precioCondicion.plazos.sort(function(a, b) { 
                                    return a.dias- b.dias;
                                });
                                $scope.plazoACargar =
                                {
                                    item: datos.data.length + 1
                                };
                            });
                    }
                });

            $timeout(function() {getLSPrecioC();});

            $timeout(function() {
                focaBotoneraLateralService.showSalir(false);
                focaBotoneraLateralService.showPausar(true);
                focaBotoneraLateralService.showCancelar(false);
                focaBotoneraLateralService.showGuardar(true, $scope.guardar);
                focaBotoneraLateralService.addCustomButton('Salir', $scope.salir);
            });

            $scope.salir = function() {

                    if ($scope.formPrecioCondicion.$pristine == false) {
                        focaModalService.confirm(
                            '¿Está seguro de que desea salir? Se perderán todos los datos cargados.'
                        ).then(function(data) {
                            if (data) {
                                $location.path('/precio-condicion');
                            }
                        });
                    } else {
                        $location.path('/precio-condicion');
                    }
            };
            $scope.guardar = function() {

                if (!$scope.precioCondicion.nombre) {
                    focaModalService.alert('Ingrese nombre');
                    return;
                } else if (!$scope.precioCondicion.descripcion) {
                    focaModalService.alert('Ingrese descripcion');
                    return;
                } else if (!$scope.precioCondicion.idListaPrecio) {
                    focaModalService.alert('Seleccione precio');
                    return;
                }

                var promises = [];
                var precioCondicion = $scope.precioCondicion;
                precioCondicion.idListaPrecio = precioCondicion.listaPrecio.ID;
                delete precioCondicion.listaPrecio;
                if ($scope.mostrarPlazos) {
                    promises.push(
                        focaAbmPreciosCondicionesService
                            .guardarPlazosPago($scope.precioCondicion.plazos)
                    );
                    $scope.plazosAEliminar.forEach(function(id) {
                        promises.push(
                            focaAbmPreciosCondicionesService
                                .borrarPlazoPago(id)
                        );
                    });
                }
                promises.push(
                    focaAbmPreciosCondicionesService
                        .guardarPrecioCondicion(precioCondicion)
                );

                Promise.all(promises).then(function() {
                    $timeout(function() {
                        $location.path('/precio-condicion');
                    }, 0);
                }, function(err){
                    console.error(err);
                });
            };

            $scope.agregarPlazo = function(key) {
                if (key === 13) {
                    if (!$scope.plazoACargar.dias && $scope.plazoACargar.dias !== 0) {
                        focaModalService.alert('Ingrese cantidad de días');
                        return;
                    }
                    var tieneEseDia = $scope.precioCondicion.plazos.filter(function(a) {
                        return a.dias === $scope.plazoACargar.dias;
                    });
                    if (tieneEseDia.length > 0) {
                        focaModalService.alert('Ya ha ingresado un plazo con esos días');
                        return;
                    }
                    $scope.plazoACargar.idPreciosCondiciones = $scope.precioCondicion.id;
                    $scope.plazoACargar.activo = true;
                    $scope.precioCondicion.plazos.push($scope.plazoACargar);
                    $scope.plazoACargar =
                    {
                        item: $scope.precioCondicion.plazos.length + 1
                    };
                }
            };
            $scope.quitarPlazo = function(key) {
                if ($scope.precioCondicion.plazos[key].id)
                    $scope.plazosAEliminar.push($scope.precioCondicion.plazos[key].id);

                $scope.precioCondicion.plazos.splice(key, 1);
                $scope.plazoACargar =
                { 
                    item: $scope.precioCondicion.plazos.length + 1
                };
            };
            $scope.solicitarConfirmacionPlazoPago = function(plazoPago) {
                focaModalService.confirm('¿Está seguro que desea borrar el plazo de pago ' +
                    plazoPago.item + ' ' + plazoPago.dias + ' ?').then(
                        function(confirm) {
                            if (confirm) {
                                focaAbmPreciosCondicionesService.borrarPlazoPago(plazoPago.id);
                                $scope.precioCondicion.plazos.splice(
                                    $scope.precioCondicion.plazos.indexOf(plazoPago), 1
                                );
                            }
                        }
                    );
            };

            $scope.seleccionarListaPrecio = function(key) {
                if (key === 13){
                    var modalInstance = $uibModal.open(
                        {
                            ariaLabelledBy: 'Busqueda de Listas de precio',
                            templateUrl: 'modal-lista-precio.html',
                            controller: 'focaModalListaPrecioCtrl',
                            size: 'lg'
                        }
                    );
                    modalInstance.result.then(function(listaPrecio) {    
                        $scope.precioCondicion.idListaPrecio = listaPrecio.ID;
                        $scope.precioCondicion.listaPrecio = listaPrecio;
                        $scope.listaPrecioLabel = listaPrecio.ID + ' - ' + listaPrecio.DES;
                        $scope.focused = 4;
                    });
                }
            };

            $scope.verProductosListaPrecio = function() {
                $uibModal.open(
                    {
                        ariaLabelledBy: 'Busqueda de Productos',
                        templateUrl: 'modal-busqueda-productos.html',
                        controller: 'modalBusquedaProductosCtrl',
                        resolve: {
                            parametroProducto: {
                                idLista: $scope.precioCondicion.listaPrecio.ID,
                                cotizacion: 1,
                                simbolo: '$',
                                soloMostrar: true
                            }
                        },
                        size: 'md'
                    }
                );
            };

            $scope.next = function(key) {
                if (key === 13) $scope.focused++;
            };

            //watch
            $scope.$watch('precioCondicion', function(newValue) {
                focaBotoneraLateralService.setPausarData({
                    label: 'precioCondicion',
                    val: newValue
                });
            }, true);
            
            function setearPrecioCondicion(precioCondicion) {
                $scope.precioCondicion = precioCondicion;
                $scope.$broadcast('addCabecera', {
                    label: 'Precio y Condicion:',
                    valor: $filter('rellenarDigitos')(precioCondicion.id)
                });
            }

            function getLSPrecioC() {
                var precioCondicion = JSON.parse($localStorage.precioCondicion || null);
                
                if (precioCondicion) {
                    setearPrecioCondicion(precioCondicion);
                    delete $localStorage.precioCondicion;
                }
            }
        }
    ]);
