angular.module('focaAbmPreciosCondiciones')
    .service('focaAbmPreciosCondicionesService', [
        '$http', 'API_ENDPOINT',
        function($http, API_ENDPOINT) {
            return {
                obtenerPreciosCondiciones: function(nombre) {
                    return $http.post(API_ENDPOINT.URL + '/precios-condiciones', {nombre: nombre});
                },
                obtenerPrecioCondicion: function(id) {
                    return $http.get(API_ENDPOINT.URL + '/precio-condicion/' + id);
                },
                guardarPrecioCondicion: function(precioCondicion) {
                    return $http.post(
                        API_ENDPOINT.URL + '/precio-condicion',
                        {precioCondicion: precioCondicion}
                    );
                },
                borrarPrecioCondicion: function(id) {
                    return $http.delete(API_ENDPOINT.URL + '/precio-condicion/' + id);
                },
                obtenerPlazoPago: function(idPrecioCondicion) {
                    return $http.get(
                        API_ENDPOINT.URL + '/plazo-pago/precio-condicion/' + idPrecioCondicion
                    );
                },
                borrarPlazoPago: function(id) {
                    return $http.delete(API_ENDPOINT.URL + '/plazo-pago/' + id);
                },
                guardarPlazosPago: function(plazos) {
                    return $http.post(
                        API_ENDPOINT.URL + '/plazos-pago',
                        {plazosPago: plazos}
                    );
                }
            };
        }
    ]);
