describe('Controladores abm vendedor cobrador', function() {

    var $controller;

    beforeEach(function() {
        module('focaAbmVendedorCobrador');
        inject(function(_$controller_) {
            $controller = _$controller_;
        });
    });
    describe('controlador focaAbmVendedoresCobradoresController', function() {

        var focaBotoneraLateralService = {
            showSalir: function() { },
            showPausar: function() { },
            showCancelar: function() { },
            showGuardar: function() { }
        };

        it('existe el controlador focaAbmVendedoresCobradoresController', function() {
            //act
            var controlador = $controller('focaAbmVendedoresCobradoresController', {
                $scope: {},
                focaAbmVendedorCobradorService: {},
                $location: {},
                $localStorage: {},
                $filter: {},
                focaBotoneraLateralService: focaBotoneraLateralService,
                focaModalService: {}
            });

            //arrange
            expect(typeof controlador).toEqual('object');
        });

        it('la función $scope.editar llama a la url correcta', function() {
            inject(function($location) {

                //arrange
                var scope = {};
                $controller('focaAbmVendedoresCobradoresController', {
                    $scope: scope,
                    focaAbmVendedorCobradorService: {},
                    $location: $location,
                    $localStorage: {},
                    $filter: {},
                    focaBotoneraLateralService: focaBotoneraLateralService,
                    focaModalService: {}
                });
                var paramFake = 1;

                //act
                scope.editar(paramFake);
                //arrange
                expect($location.url()).toEqual('/vendedor-cobrador/' + paramFake);
            });
        });

        it('la función $scope.eliminar llama a modal confirmar', function() {
            inject(function($location) {

                //arrange
                var scope = {};
                var focaModalService = {
                    confirm: function() { }
                };
                $controller('focaAbmVendedoresCobradoresController', {
                    $scope: scope,
                    focaAbmVendedorCobradorService: {},
                    $location: $location,
                    $localStorage: {},
                    $filter: {},
                    focaBotoneraLateralService: focaBotoneraLateralService,
                    focaModalService: focaModalService
                });
                var paramFake = 1;

                //act
                spyOn(focaModalService, 'confirm').and.returnValue({ then: function() { } });
                scope.eliminar(paramFake);

                //arrange
                expect(focaModalService.confirm).toHaveBeenCalled();
            });
        });

        it('función $scope.eliminar llama eliminarVendedorCobrador al confirm ok', function(done) {
            inject(function($location) {

                //arrange
                var scope = {};
                var focaModalService = {
                    confirm: function() { }
                };
                var focaAbmVendedorCobradorService = {
                    eliminarVendedorCobrador: function() { }
                };
                $controller('focaAbmVendedoresCobradoresController', {
                    $scope: scope,
                    focaAbmVendedorCobradorService: focaAbmVendedorCobradorService,
                    $location: $location,
                    $localStorage: {},
                    $filter: {},
                    focaBotoneraLateralService: focaBotoneraLateralService,
                    focaModalService: focaModalService
                });
                var paramFake = 1;
                var promesaConfirmar = Promise.resolve(true);

                //act
                spyOn(focaModalService, 'confirm').and.returnValue(promesaConfirmar);
                spyOn(focaAbmVendedorCobradorService, 'eliminarVendedorCobrador')
                    .and.returnValue({ then: function() { } });
                scope.eliminar(paramFake);

                //arrange
                promesaConfirmar.then(function() {
                    expect(focaAbmVendedorCobradorService.eliminarVendedorCobrador)
                        .toHaveBeenCalled();
                    done();
                });
            });
        });

        it('función $scope.resetPage llama a $scope.selectPage', function() {

            //arrange
            var scope = {};
            $controller('focaAbmVendedoresCobradoresController', {
                $scope: scope,
                focaAbmVendedorCobradorService: {},
                $location: {},
                $localStorage: {},
                $filter: {},
                focaBotoneraLateralService: focaBotoneraLateralService,
                focaModalService: {}
            });

            //act
            spyOn(scope, 'selectPage');
            scope.resetPage();

            //arrange
            expect(scope.selectPage).toHaveBeenCalled();
        });

        it('función $scope.search llama a getVendedoresCobradores', function() {

            //arrange
            var scope = {};
            var focaAbmVendedorCobradorService = {
                getVendedoresCobradores: function() { }
            };
            $controller('focaAbmVendedoresCobradoresController', {
                $scope: scope,
                focaAbmVendedorCobradorService: focaAbmVendedorCobradorService,
                $location: {},
                $localStorage: {},
                $filter: {},
                focaBotoneraLateralService: focaBotoneraLateralService,
                focaModalService: {}
            });

            //act
            spyOn(focaAbmVendedorCobradorService, 'getVendedoresCobradores')
                .and.returnValue({ then: function() { } });
            scope.search(13);

            //arrange
            expect(focaAbmVendedorCobradorService.getVendedoresCobradores).toHaveBeenCalled();
        });

        it('función scope.search llama getVendedoresCobradores y llama resetPage', function(done) {

            //arrange
            var scope = {};
            var focaAbmVendedorCobradorService = {
                getVendedoresCobradores: function() { }
            };
            $controller('focaAbmVendedoresCobradoresController', {
                $scope: scope,
                focaAbmVendedorCobradorService: focaAbmVendedorCobradorService,
                $location: {},
                $localStorage: {},
                $filter: {},
                focaBotoneraLateralService: focaBotoneraLateralService,
                focaModalService: {}
            });
            var promesaVendedores = Promise.resolve({ data: [] });

            //act
            spyOn(focaAbmVendedorCobradorService, 'getVendedoresCobradores')
                .and.returnValue(promesaVendedores);
            spyOn(scope, 'resetPage');
            scope.vendedoresCobradores = [];
            scope.search(13);

            //arrange
            promesaVendedores.then(function() {
                expect(scope.resetPage).toHaveBeenCalled();
                done();
            });
        });
    });

    describe('Controlador focaAbmVendedorCobradorController', function() {

        var timeout;

        beforeEach(function() {
            inject(function($timeout) {
                timeout = $timeout;
            });
        });

        it('existe el controlador focaAbmVendedorCobradorController', function() {

            //act
            var controlador = $controller('focaAbmVendedorCobradorController', {
                $scope: {
                    $watch: function() {}
                },
                focaAbmVendedorCobradorService: {
                    getCodigoSiguiente: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getVendedorCobradorById: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $routeParams: {},
                focaBotoneraLateralService: {},
                $timeout: timeout,
                $uibModal: {},
                $location: {},
                $localStorage: {},
                focaModalService: {
                }
            });

            //assert
            expect(typeof controlador).toEqual('object');
        });

        it('la función $scope.guardar llama a guardaVendedorCobrador del servicio', function() {
            //arrange
            var scope = {
                $watch: function() {},
            };  
            var focaAbmVendedorCobradorService = {
                getCodigoSiguiente: function() {
                    return {
                        then: function() { }
                    };
                },
                getVendedorCobradorById: function() {
                    return {
                        then: function() { }
                    };
                },
                guardarVendedorCobrador: function() { }
            };
            $controller('focaAbmVendedorCobradorController', {
                $scope: scope,
                focaAbmVendedorCobradorService: focaAbmVendedorCobradorService,
                $routeParams: {},
                focaBotoneraLateralService: {},
                $timeout: timeout,
                $uibModal: {},
                $location: {},
                $localStorage: {},
                guardarVendedorCobrador: {},
                focaModalService: {
                    alert: function() {}
                }
            });
            var responseFake = {
                then: function() {
                    return {
                        catch: function() { }
                    };
                }
            };
            scope.vendedorCobrador = {
                NOM: true,
                domicilio: true,
                codigoPostal: true,
                dni: true,
                rol: true,
                provincia: {
                    NOMBRE: true
                },
                localidad: {
                    NOMBRE: true
                },
            };

            //act
            spyOn(focaAbmVendedorCobradorService, 'guardarVendedorCobrador')
                .and.returnValue(responseFake);
            scope.guardar();

            //assert
            expect(focaAbmVendedorCobradorService.guardarVendedorCobrador).toHaveBeenCalled();
        });

        it('la función $scope.guardar llama a guardaVendedorCobrador y edicion true ' +
            'llama a $location.path', function(done)
        {
            inject(function($location) {
                
                //arrange
                var scope= {
                    $watch: function(){},
                };
                var focaAbmVendedorCobradorService = {
                    getCodigoSiguiente: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getVendedorCobradorById: function() {
                        return {
                            then: function() { }
                        };
                    },
                    guardarVendedorCobrador: function() { }
                };
                $controller('focaAbmVendedorCobradorController', {
                    $scope: scope,
                    focaAbmVendedorCobradorService: focaAbmVendedorCobradorService,
                    $routeParams: {},
                    focaBotoneraLateralService: {},
                    $timeout: timeout,
                    $uibModal: {},
                    $location: $location,
                    $localStorage: {},
                    focaModalService: {
                        alert: function() {}
                    }
                });
                var promiseFake = Promise.resolve(true, false);

                scope.vendedorCobrador = {
                    NOM: true,
                    domicilio: true,
                    codigoPostal: true,
                    dni: true,
                    rol: true,
                    provincia: {
                        NOMBRE: true
                    },
                    localidad: {
                        NOMBRE: true
                    },
                };

                //act
                spyOn(focaAbmVendedorCobradorService, 'guardarVendedorCobrador')
                    .and.returnValue(promiseFake);
                scope.edicion = true;
                scope.guardar();
                
                //assert
                promiseFake.then(function() {
                    expect($location.url()).toEqual('/vendedor-cobrador');
                    done();
                });
            });
        });

        it('la función $scope.guardar llama a guardaVendedorCobrador y scope.edicion false ' +
            'llama a scope.cambiarContraseña', function(done)
        {
            //arrange
            var scope= {
                $watch: function() {}
            };
            var focaAbmVendedorCobradorService = {
                getCodigoSiguiente: function() {
                    return {
                        then: function() { }
                    };
                },
                getVendedorCobradorById: function() {
                    return {
                        then: function() { }
                    };
                },
                guardarVendedorCobrador: function() { }
            };
            $controller('focaAbmVendedorCobradorController', {
                $scope: scope,
                focaAbmVendedorCobradorService: focaAbmVendedorCobradorService,
                $routeParams: {},
                focaBotoneraLateralService: {},
                $timeout: timeout,
                $uibModal: {},
                $location: {},
                $localStorage: {},
                focaModalService: {
                    alert: function() {}
                }
            });
            var promiseFake = Promise.resolve(true, false);

            scope.vendedorCobrador = {
                NOM: true,
                domicilio: true,
                codigoPostal: true,
                dni: true,
                rol: true,
                provincia: {
                    NOMBRE: true
                },
                localidad: {
                    NOMBRE: true
                },
            };

            //act
            spyOn(focaAbmVendedorCobradorService, 'guardarVendedorCobrador')
                .and.returnValue(promiseFake);
            spyOn(scope, 'cambiarPassword');
            scope.edicion = false;
            scope.guardar();
            
            //assert
            promiseFake.then(function() {
                expect(scope.cambiarPassword).toHaveBeenCalled();
                done();
            });
        });

        it('la función $scope.guardar llama a guardaVendedorCobrador y llama foca modal alert' +
            'cuando la promesa es rechazada y el error es 409', function(done)
        {
            //arrange
            var scope= {
                $watch: function() {}
            };
            var focaAbmVendedorCobradorService = {
                getCodigoSiguiente: function() {
                    return {
                        then: function() { }
                    };
                },
                getVendedorCobradorById: function() {
                    return {
                        then: function() { }
                    };
                },
                guardarVendedorCobrador: function() { }
            };
            var focaModalService = {
                alert: function() { }
            };
            $controller('focaAbmVendedorCobradorController', {
                $scope: scope,
                focaAbmVendedorCobradorService: focaAbmVendedorCobradorService,
                $routeParams: {},
                focaBotoneraLateralService: {},
                $timeout: timeout,
                $uibModal: {},
                $location: {},
                $localStorage: {},
                focaModalService: focaModalService
            });
            var promiseFake = Promise.reject({ status: 409 });

            //act
            spyOn(focaAbmVendedorCobradorService, 'guardarVendedorCobrador')
                .and.returnValue(promiseFake);
            spyOn(focaModalService, 'alert');
            scope.guardar();
            
            //assert
            promiseFake.catch(function() {
                setTimeout(function() {
                    expect(focaModalService.alert).toHaveBeenCalled();
                    done();
                }, 100);
            });
        });

        it('la función $scope.seleccionarProvincia llama a foca Modal', function() {
            //arrange
            var scope= {
                $watch: function() {}
            };
            var focaAbmVendedorCobradorService = {
                getCodigoSiguiente: function() {
                    return {
                        then: function() { }
                    };
                },
                getVendedorCobradorById: function() {
                    return {
                        then: function() { }
                    };
                },
            };
            var focaModalService = {
                modal: function() { }
            };
            $controller('focaAbmVendedorCobradorController', {
                $scope: scope,
                focaAbmVendedorCobradorService: focaAbmVendedorCobradorService,
                $routeParams: {},
                focaBotoneraLateralService: {},
                $timeout: timeout,
                $uibModal: {},
                $location: {},
                $localStorage: {},
                focaModalService: focaModalService
            });

            //act
            spyOn(focaModalService, 'modal').and.returnValue({ then: function() { } });
            scope.seleccionarProvincia(13);

            //assert
            expect(focaModalService.modal).toHaveBeenCalled();
        });

        it('función $scope.seleccionarLocalidad llama foca alert si no hay provincia', function() {
            //arrange
            var scope = {
                $watch: function() {}
            };
            var focaAbmVendedorCobradorService = {
                getCodigoSiguiente: function() {
                    return {
                        then: function() { }
                    };
                },
                getVendedorCobradorById: function() {
                    return {
                        then: function() { }
                    };
                },
            };
            var focaModalService = {
                alert: function() { }
            };
            $controller('focaAbmVendedorCobradorController', {
                $scope: scope,
                focaAbmVendedorCobradorService: focaAbmVendedorCobradorService,
                $routeParams: {},
                focaBotoneraLateralService: {},
                $timeout: timeout,
                $uibModal: {},
                $location: {},
                $localStorage: {},
                focaModalService: focaModalService
            });

            //act
            spyOn(focaModalService, 'alert');
            scope.vendedorCobrador.provincia.ID = false;
            scope.seleccionarLocalidad();

            //assert
            expect(focaModalService.alert).toHaveBeenCalled();
        });

        it('función $scope.seleccionarLocalidad llama foca modal', function() {
            //arrange
            var scope= {
                $watch: function() {}
            };
            var focaAbmVendedorCobradorService = {
                getCodigoSiguiente: function() {
                    return {
                        then: function() { }
                    };
                },
                getVendedorCobradorById: function() {
                    return {
                        then: function() { }
                    };
                },
            };
            var focaModalService = {
                modal: function() { }
            };
            $controller('focaAbmVendedorCobradorController', {
                $scope: scope,
                focaAbmVendedorCobradorService: focaAbmVendedorCobradorService,
                $routeParams: {},
                focaBotoneraLateralService: {},
                $timeout: timeout,
                $uibModal: {},
                $location: {},
                $localStorage: {},
                focaModalService: focaModalService
            });

            //act
            spyOn(focaModalService, 'modal').and.returnValue({ then: function() { } });
            scope.vendedorCobrador.provincia.ID = true;
            scope.seleccionarLocalidad(13);

            //assert
            expect(focaModalService.modal).toHaveBeenCalled();
        });

        it('la función scope.cancelar lleva a location correcte', function() {

            inject(function($location) {
                //arrange
                var scope = {
                    $watch: function() {}
                };
                $controller('focaAbmVendedorCobradorController', {
                    $scope: scope,
                    focaAbmVendedorCobradorService: {
                        getCodigoSiguiente: function() {
                            return {
                                then: function() { }
                            };
                        },
                        getVendedorCobradorById: function() {
                            return {
                                then: function() { }
                            };
                        }
                    },
                    $routeParams: {},
                    focaBotoneraLateralService: {},
                    $timeout: timeout,
                    $uibModal: {},
                    $location: $location,
                    $localStorage: {},
                    focaModalService: {}
                });

                //act
                scope.formVendedorCobrador = {
                    $pristine: true
                };
                scope.cancelar();

                //assert
                expect($location.url()).toEqual('/vendedor-cobrador');
            });
        });

        it('la funcion scope.next suma uno a scope.focused', function() {

            //arrange
            var scope = {
                $watch: function() {}
            };
            $controller('focaAbmVendedorCobradorController', {
                $scope: scope,
                focaAbmVendedorCobradorService: {
                    getCodigoSiguiente: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getVendedorCobradorById: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $routeParams: {},
                focaBotoneraLateralService: {},
                $timeout: timeout,
                $uibModal: {},
                $location: {},
                $localStorage:  {},
                focaModalService: {}
            });

            //act
            var esperado = scope.focused + 1;
            scope.next(13);

            //assert
            expect(scope.focused).toEqual(esperado);
        });

        it('la funcion scope.cambiarPassword abre modal', function() {

            //arrange
            var scope = {
                $watch: function() {}
            };
            var uibModal = {
                open: function() { }
            };
            $controller('focaAbmVendedorCobradorController', {
                $scope: scope,
                focaAbmVendedorCobradorService: {
                    getCodigoSiguiente: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getVendedorCobradorById: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $routeParams: {},
                focaBotoneraLateralService: {},
                $timeout: timeout,
                $uibModal: uibModal,
                $location: {},
                $localStorage: {},
                focaModalService: {}
            });
            var responseFake = {
                result: {
                    then: function() { }
                }
            };

            //act
            spyOn(uibModal, 'open').and.returnValue(responseFake);
            scope.cambiarPassword();

            //assert
            expect(uibModal.open).toHaveBeenCalled();
        });

        it('la funcion scope.cambiarPassword abre modal y llama a location cuando edicion es ' +
            'falso', function(done)
        {
            inject(function($location) {

                //arrange
                var scope = {
                    $watch: function() {}
                };
                var uibModal = {
                    open: function() { }
                };
                $controller('focaAbmVendedorCobradorController', {
                    $scope: scope,
                    focaAbmVendedorCobradorService: {
                        getCodigoSiguiente: function() {
                            return {
                                then: function() { }
                            };
                        },
                        getVendedorCobradorById: function() {
                            return {
                                then: function() { }
                            };
                        }
                    },
                    $routeParams: {},
                    focaBotoneraLateralService: {},
                    $timeout: timeout,
                    $uibModal: uibModal,
                    $location: $location,
                    $localStorage: {},
                    focaModalService: {}
                });
                var responseFake = {
                    result: Promise.resolve(true)
                };

                //act
                spyOn(uibModal, 'open').and.returnValue(responseFake);
                scope.edicion = false;
                scope.cambiarPassword();

                //assert
                responseFake.result.then(function() {
                    expect($location.url()).toEqual('/vendedor-cobrador');
                    done();
                });
            });
        });
    });
});
