describe('Servicios abm vendedor cobrador', function() {

    var httpBackend;

    beforeEach(function() {
        module('focaAbmVendedorCobrador');

        inject(module(function($provide) {
            $provide.value('API_ENDPOINT', {
                URL: 'local'
            });
        }));

        inject(function($httpBackend) {
            httpBackend = $httpBackend;
        });
    });

    describe('Servicio focaAbmVendedorCobradorService', function() {

        var servicio;

        beforeEach(inject(function(focaAbmVendedorCobradorService) {
            servicio = focaAbmVendedorCobradorService;
        }));

        it('Existe el servicio focaAbmVendedorCobradorService', function() {
            //assert
            expect(typeof servicio).toEqual('object');
        });

        it('la función getVendedoresCobradores llama a la ruta correcta', function() {
            //arrange
            var result;
            var fakeResponse = { data: 'test' };
            var fakeBody = 2;
            httpBackend.expectPOST('local/vendedor-cobrador/list', { nombre: fakeBody })
                .respond(fakeResponse);

            //act
            servicio.getVendedoresCobradores(fakeBody).then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(fakeResponse);
        });

        it('la función getVendedorCobradorById llama a la ruta correcta', function() {
            //arrange
            var result;
            var fakeResponse = { data: 'test' };
            var fakeParam = 1;
            httpBackend.expectGET('local/vendedor-cobrador/' + fakeParam).respond(fakeResponse);

            //act
            servicio.getVendedorCobradorById(fakeParam).then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(fakeResponse);
        });

        it('la función guardarVendedorCobrador llama a la ruta correcta', function() {
            //arrange
            var result;
            var fakeResponse = { data: 'test' };
            var fakeBody = 1;
            httpBackend.expectPOST('local/vendedor-cobrador', { vendedorCobrador: fakeBody })
                .respond(fakeResponse);

            //act
            servicio.guardarVendedorCobrador(fakeBody).then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(fakeResponse);
        });

        it('la función eliminarVendedorCobrador llama a la ruta correcta', function() {
            //arrange
            var result;
            var fakeResponse = { data: 'test' };
            var fakeParam = 1;
            httpBackend.expectDELETE('local/vendedor-cobrador/' + fakeParam)
                .respond(fakeResponse);

            //act
            servicio.eliminarVendedorCobrador(fakeParam).then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(fakeResponse);
        });

        it('la función getCodigoSiguiente llama a la ruta correcta', function() {
            //arrange
            var result;
            var fakeResponse = { data: 'test' };
            httpBackend.expectGET('local/vendedor-cobrador/obtener/siguiente-codigo')
                .respond(fakeResponse);

            //act
            servicio.getCodigoSiguiente().then(function(data) {
                result = data.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(fakeResponse);
        });
    });
});
