angular.module('focaAbmVendedorCobrador')
    .controller('focaAbmVendedoresCobradoresController', [
        '$scope', 'focaAbmVendedorCobradorService', '$location', '$filter', 
        'focaBotoneraLateralService', 'focaModalService', '$localStorage',
        function($scope, focaAbmVendedorCobradorService, $location, $filter,
            focaBotoneraLateralService, focaModalService, $localStorage) {
            $scope.now = new Date();
            $scope.vendedoresCobradores = [];
            $scope.filters = '';
            $scope.numPerPage = 10;
            $scope.currentPageVendedoresCobradores = [];
            $scope.vendedoresCobradores = [];

            //SETEO BOTONERA LATERAL
            focaBotoneraLateralService.showSalir(true);
            focaBotoneraLateralService.showPausar(false);
            focaBotoneraLateralService.showCancelar(false);
            focaBotoneraLateralService.showGuardar(false);
            
            $scope.editar = function(id) {
                $location.path('/vendedor-cobrador/' + id);
            };

            $scope.eliminar = function(vendedorCobrador) {
                var tipo = !!(vendedorCobrador.rol | 2) ? 'cobrador' : 'vendedor';
                focaModalService.confirm('¿Está seguro que desea borrar el ' + tipo +
                    ' ' + vendedorCobrador.NOM + '?')
                    .then(function(data) {
                        if (data) {
                            focaAbmVendedorCobradorService
                            .eliminarVendedorCobrador(vendedorCobrador.id)
                            .then(function() {
                                $scope.search(13);
                            });
                        }
                });
            };

            $scope.selectPage = function(page) {
                var start = (page - 1) * $scope.numPerPage;
                var end = start + $scope.numPerPage;
                $scope.paginas = [];
                $scope.paginas = calcularPages(page);
                $scope.currentPageVendedoresCobradores =
                    $scope.vendedoresCobradores.slice(start, end);
                $scope.currentPage = page;
            };

            $scope.resetPage = function() {
                $scope.currentPage = 1;
                $scope.selectPage(1);
            };

            $scope.search = function(key) {
                if (key !== 13) return;

                focaAbmVendedorCobradorService
                    .getVendedoresCobradores($scope.filters)
                    .then(function(res) {
                        $scope.vendedoresCobradores = res.data;

                        $scope.lastPage = Math.ceil(
                            $scope.vendedoresCobradores.length / $scope.numPerPage
                        );
        
                        $scope.resetPage();
                    });
            };

            if ($localStorage.vendedorCobrador) {
                var vendedorCobrador = JSON.parse($localStorage.vendedorCobrador);
                $location.path('/vendedor-cobrador/' + vendedorCobrador.NUM);
            }

            function calcularPages(paginaActual) {
                var paginas = [];
                paginas.push(paginaActual);

                if (paginaActual - 1 > 1) {
                    
                    paginas.unshift(paginaActual - 1);
                    if (paginaActual - 2 > 1) {
                        paginas.unshift(paginaActual - 2);
                    }
                }

                if (paginaActual + 1 < $scope.lastPage) {
                    paginas.push(paginaActual + 1);
                    if (paginaActual + 2 < $scope.lastPage) {
                        paginas.push(paginaActual + 2);
                    }
                }

                if (paginaActual !== 1) {
                    paginas.unshift(1);
                }

                if (paginaActual !== $scope.lastPage) {
                    paginas.push($scope.lastPage);
                }
                return paginas;
            }
            
            // TODO: descomentar cuando se use
            // function primera() {
            //     $scope.selectedClientes = 0;
            // }

            // function anterior() {
            //     if ($scope.selectedClientes === 0 && $scope.currentPage > 1) {
            //         retrocederPagina();
            //     } else {
            //         $scope.selectedClientes--;
            //     }
            // }

            // function siguiente() {
            //     if ($scope.selectedClientes < $scope.currentPageVendedoresCobradores.length - 1 )
            //{
            //         $scope.selectedClientes++;
            //     } else {
            //             avanzarPagina();
            //     }
            // }

            // function retrocederPagina() {
            //     if ($scope.currentPage > 1) {
            //         $scope.selectPage($scope.currentPage - 1);
            //         $scope.selectedClientes = $scope.numPerPage - 1;
            //     }
            // }

            // function avanzarPagina() {
            //     if ($scope.currentPage < $scope.lastPage) {
            //         $scope.selectPage($scope.currentPage + 1);
            //         $scope.selectedClientes = 0;
            //     }
            // }
        }
    ]);
