angular.module('focaAbmVendedorCobrador')
    .controller('focaAbmVendedorCobradorController', [
        '$scope', 'focaAbmVendedorCobradorService', '$routeParams', 'focaBotoneraLateralService',
        '$timeout', '$uibModal', '$location', 'focaModalService', '$localStorage', '$filter',
        function($scope, focaAbmVendedorCobradorService, $routeParams, focaBotoneraLateralService,
            $timeout, $uibModal, $location, focaModalService, $localStorage, $filter) {

            $scope.guardado = false;
            $scope.now = new Date();
            $scope.focused = 0;
            $scope.vendedorCobrador = {
                dni: '',
                CNET: '0',
                CFIN: '0',
                CCOB: '0',
                comisionVendedor: '0.00',
                comisionCobrador: '0.00',
                provincia: {
                    NOMBRE: ''
                },
                localidad: {
                    NOMBRE: ''
                },
                rol: ''
            };
            $scope.options = [
                {
                    label: 'Vendedor',
                    value: 1
                },
                {
                    label: 'Cobrador',
                    value: 2
                },
                {
                    label: 'Vendedor y cobrador',
                    value: 3
                }
            ];
            //SETEO BOTONERA LATERAL
            $timeout(function() {
                focaBotoneraLateralService.showSalir(false);
                focaBotoneraLateralService.showPausar(true);
                focaBotoneraLateralService.showCancelar(false);
                focaBotoneraLateralService.showGuardar(true, $scope.guardar);
                focaBotoneraLateralService.addCustomButton('Salir', $scope.cancelar);
            });
            
            $timeout(function() {getLSVendedor();});

            focaAbmVendedorCobradorService
                .getCodigoVendedores()
                .then(function (res) {
                    $scope.vendedorCobrador.NUM = res.data.proximoCodigo;
                });

            focaAbmVendedorCobradorService
                .getVendedorCobradorById($routeParams.id)
                .then(function(res) {
                    if (res.data) {
                        $scope.edicion = true;
                        $scope.vendedorCobrador = res.data;
                    }
                });

            $scope.guardar = function() {
                var cobradorComision = parseFloat($scope.vendedorCobrador.comisionCobrador);
                var vendedorComision = parseFloat($scope.vendedorCobrador.comisionVendedor);

                if (!$scope.vendedorCobrador.NOM) {
                    focaModalService.alert('Ingrese nombre');
                    return;
                } else if (!$scope.vendedorCobrador.domicilio) {
                    focaModalService.alert('Ingrese domicilio');
                    return;
                } else if (!$scope.vendedorCobrador.codigoPostal) {
                    focaModalService.alert('Ingrese código postal');
                    return;
                } else if (!$scope.vendedorCobrador.dni) {
                    focaModalService.alert('Ingrese dni');
                    return;
                } else if (!$scope.vendedorCobrador.rol) {
                    focaModalService.alert('Seleccione tipo');
                    return;
                } else if (!$scope.vendedorCobrador.provincia.NOMBRE) {
                    focaModalService.alert('Seleccione una provincia');
                    return;
                } else if (!$scope.vendedorCobrador.localidad.NOMBRE) {
                    focaModalService.alert('Seleccione una localidad');
                    return;
                } else if (($scope.vendedorCobrador.rol === 2 && isNaN(cobradorComision)) || 
                          (($scope.vendedorCobrador.rol === 3) && isNaN(cobradorComision))) {
                    focaModalService.alert('Ingrese una comision cobrador válida');
                    return;
                } else if (($scope.vendedorCobrador.rol === 1 && isNaN(vendedorComision)) || 
                          ($scope.vendedorCobrador.rol === 3 && isNaN(vendedorComision))) {
                    focaModalService.alert('Ingrese una comision vendedor válida');
                    return;
                }

                if ($scope.guardado) {
                    $scope.cambiarPassword();
                } else {

                    var vendedorCobrador = angular.copy($scope.vendedorCobrador);

                    vendedorCobrador.idProvincia = vendedorCobrador.provincia.ID;
                    vendedorCobrador.idLocalidad = vendedorCobrador.localidad.ID;

                    delete vendedorCobrador.provincia;
                    delete vendedorCobrador.localidad;
                    if (vendedorCobrador.rol === 1) {
                        delete vendedorCobrador.comisionCobrador;
                    } else if (vendedorCobrador.rol === 2) {
                        delete vendedorCobrador.comisionVendedor;
                    }
                    vendedorCobrador.metodo = ($routeParams.id === '0') ? 'crear' : 'actualizar';

                    focaAbmVendedorCobradorService
                        .guardarVendedorCobrador(vendedorCobrador)
                        .then(function(res) {
                            if ($scope.edicion) {
                                $location.path('/vendedor-cobrador');
                            } else {
                                $scope.vendedorCobrador = res.data;
                                $scope.cambiarPassword();
                                $scope.guardado = true;
                            }
                        })
                        .catch(function(err) {
                            if (err.status === 409) {
                                focaModalService.alert(err.data);
                            }
                        });
                }
            };

            $scope.seleccionarProvincia = function(key) {
                if (key === 13) {
                    var parametrosModal = {
                        searchText: $scope.vendedorCobrador.provincia.NOMBRE,
                        query: '/provincia',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Codigo',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de provincias',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(function(provincia) {
                        $scope.vendedorCobrador.provincia = provincia;
                        $timeout(function() {
                            $scope.focused = 5;
                        });
                    }, function() {
                        //TODO: función llamada cuando cancela el modal
                    });
                }
            };
            
            $scope.seleccionarLocalidad = function(key) {
                if (!$scope.vendedorCobrador.provincia.ID) {
                    focaModalService.alert('Seleccione una provincia');
                    return;
                }
                if (key === 13) {
                    var parametrosModal = {
                        searchText: $scope.vendedorCobrador.localidad.NOMBRE,
                        query: '/localidad/' + $scope.vendedorCobrador.provincia.ID,
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de localidades',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(function(localidad) {
                        $scope.vendedorCobrador.localidad = localidad;
                        $timeout(function() {
                            $scope.focused = 6;
                        });
                    }, function() {
                        //TODO: función llamada cuando cancela el modal
                    });
                }
            };

            $scope.$watch('vendedorCobrador', function(newValue) {
                focaBotoneraLateralService.setPausarData({
                    label:'vendedorCobrador',
                    val: newValue
                });
            }, true);

            function getLSVendedor() {
                var vendedorCobrador = JSON.parse($localStorage.vendedorCobrador || null);
                if (vendedorCobrador) {
                    setearVendedor(vendedorCobrador);
                    delete $localStorage.vendedorCobrador;
                }
            }

            function setearVendedor(vendedorCobrador) {
                $scope.vendedorCobrador = vendedorCobrador;
                $scope.$broadcast('addCabecera', {
                    label: 'Vendedor / Cobrador:',
                    valor: $filter('rellenarDigitos')(vendedorCobrador.NUM, 2) +
                        ' - ' + vendedorCobrador.NOM
                });
            }
            
            $scope.cancelar = function() {
                if (!$scope.formVendedorCobrador.$pristine) {

                    focaModalService.confirm('¿Está seguro de que desea salir? ' +
                        'Se perderán todos los datos cargados.')
                        .then(function(confirmed) {
                            if (confirmed && $scope.guardado && !$scope.edicion) {

                                focaAbmVendedorCobradorService
                                    .destroyVendedorCobrador($scope.vendedorCobrador.id)
                                    .then(function() {
                                        $location.path('/vendedor-cobrador');
                                    });

                            } else if (confirmed) {
                                $location.path('/vendedor-cobrador');
                            }
                        });

                } else {
                    $location.path('/vendedor-cobrador');
                }
            };

            $scope.next = function(key) {
                if (key === 13) $scope.focused++;
            };

            $scope.cambiarPassword = function() {
                var vendedorCobrador = angular.copy($scope.vendedorCobrador);
                vendedorCobrador.nombre = vendedorCobrador.NOM;
                vendedorCobrador.codigo = vendedorCobrador.NUM;

                var parametros = {
                    cuenta: vendedorCobrador,
                    tipo: ($scope.vendedorCobrador.rol === 2) ? 'Cobradores' : 'Vendedores',
                    btnAceptar: true
                };

                var modalInstance = $uibModal.open(
                    {
                        ariaLabelledBy: 'Configuracion de Logueo',
                        templateUrl: 'modal-login.html',
                        controller: 'focaModalLoginController',
                        size: 'md',
                        resolve: {
                            parametros: function() {
                                return parametros;
                            }
                        }
                    }
                );

                modalInstance.result.then(function() {
                    if (!$scope.edicion) $location.path('/vendedor-cobrador');
                });

            };
        }
    ]);
