angular.module('focaAbmVendedorCobrador')
    .factory('focaAbmVendedorCobradorService', ['$http', 'API_ENDPOINT',
    function($http, API_ENDPOINT) {
        return {
            getVendedoresCobradores: function(nombre) {
                return $http.post(API_ENDPOINT.URL + '/vendedor-cobrador/list', {nombre: nombre});
            },
            getVendedorCobradorById: function(id) {
                return $http.get(API_ENDPOINT.URL + '/vendedor-cobrador/' + id);
            },
            guardarVendedorCobrador: function(vendedorCobrador) {
                return $http.post(API_ENDPOINT.URL + '/vendedor-cobrador',
                    {vendedorCobrador: vendedorCobrador});
            },
            eliminarVendedorCobrador: function(id) {
                return $http.delete(API_ENDPOINT.URL + '/vendedor-cobrador/' + id);
            },
            destroyVendedorCobrador: function(id) {
                return $http.delete(API_ENDPOINT.URL + '/vendedor-cobrador/destroy/' + id);
            },
            getCodigoSiguiente: function() {
                return $http.get(API_ENDPOINT.URL + '/vendedor-cobrador/obtener/siguiente-codigo');
            },
            getCodigoVendedores: function() {
                return $http.get(API_ENDPOINT.URL + '/vendedor-cobrador-proximoCodigo');
            }
        };
    }]);
