angular.module('focaBusquedaCliente')
    .controller('focaBusquedaClienteModalController', [
        '$uibModalInstance', 'focaBusquedaClienteService', '$scope', '$filter',
        '$uibModal', 'focaModalService', '$timeout', '$rootScope',
        'parametros',
        function ($uibModalInstance, focaBusquedaClienteService, $scope, $filter,
            $uibModal, focaModalService, $timeout, $rootScope,
            parametros) {

            $scope.cobrador = parametros.cobrador ? parametros.cobrador : {};
            $scope.vendedor = parametros.vendedor ? parametros.vendedor : {};
            $scope.filters = parametros.searchText ? parametros.searchText : '';
            $scope.primerBusqueda = false;

            //#region pagination
            $scope.numPerPage = 10;
            $scope.currentPage = 1;
            $scope.filteredClientes = [];
            $scope.currentPageClientes = [];
            $scope.selectedClientes = -1;
            $scope.ingreso = false;
            $scope.accion = '';
            $scope.regexCuit = new RegExp(/\b(20|23|24|27|30|33|34)(\D)?[0-9]{8}(\D)?[0-9]/);
            $scope.focused = 1;
            //#endregion

            $scope.clienteTemplate = {
                COD: 0,
                ES_MAY: true,
                cuit1: '',
                cuit2: '',
                cuit3: '',
                provincia: {
                    NOMBRE: ''
                },
                localidad: {
                    NOMBRE: ''
                },
                iva: {
                    NOMBRE: ''
                },
                actividad: {
                    NOM: ''
                },
                zona: {
                    NOM: ''
                },
                tipoFactura: {
                    NOMBRE: ''
                },
                tipoComprobante: {
                    NOMBRE: ''
                },
                formaPago: {
                    NOMBRE: ''
                },
                cobrador: {
                    NOM: ''
                }
            };
            $scope.cliente = angular.copy($scope.clienteTemplate);
            $scope.busquedaPress = function (key) {
                if (key === 13) {
                    var funcion;
                    if ($scope.vendedor.id) {
                        funcion = 'obtenerClientesPorNombreOCuitByVendedor';
                    } else if ($scope.cobrador.id) {
                        funcion = 'obtenerClientesPorNombreOCuitByCobrador';
                    } else {
                        funcion = 'obtenerClientesPorNombreOCuit';
                    }

                    $scope.searchLoading = true;
                    focaBusquedaClienteService
                    [funcion]($scope.filters, $scope.vendedor.id || $scope.cobrador.id)
                        .then(
                            function (res) {
                                $scope.primerBusqueda = true;
                                $scope.clientes = res.data;
                                $scope.search(true);
                                primera();
                                $scope.searchLoading = false;
                            });
                }
            };

            $scope.search = function (pressed) {
                if ($scope.primerBusqueda) {
                    $scope.filteredClientes = $filter('filter')(
                        $scope.clientes, { $: $scope.filters }
                    );

                    if (pressed && $scope.filteredClientes.length === 0) {
                        $timeout(function () {
                            angular.element('#search')[0].focus();
                            $scope.filters = '';
                        });
                    }

                    $scope.lastPage = Math.ceil(
                        $scope.filteredClientes.length / $scope.numPerPage
                    );

                    $scope.resetPage();
                }
            };

            $scope.resetPage = function () {
                $scope.currentPage = 1;
                $scope.selectPage(1);
            };

            $scope.selectPage = function (page) {
                var start = (page - 1) * $scope.numPerPage;
                var end = start + $scope.numPerPage;
                $scope.paginas = [];
                $scope.paginas = calcularPages(page);
                $scope.currentPageClientes = $scope.filteredClientes.slice(start, end);
                $scope.currentPage = page;
            };

            $scope.select = function (cliente, esNuevo = false) {
                cliente.esNuevo = esNuevo;
                $uibModalInstance.close(cliente);
            };

            $scope.cancel = function () {
                if ($scope.ingreso) {
                    $scope.ingreso = false;
                } else {
                    $uibModalInstance.dismiss('cancel');
                }
            };

            $scope.crearCliente = function () {
                $scope.cliente = angular.copy($scope.clienteTemplate);
                $scope.vendedor.NOM = '';
                $scope.vendedor.id = undefined;
                $scope.cliente.cobrador.NOM = '';
                $scope.cliente.cobrador.ID = undefined;
                $scope.accion = 'Crear Cliente';
                $scope.ingreso = true;
            };

            $scope.openModal = function (cliente) {
                focaBusquedaClienteService.obtenerClientePorCodigo(cliente.COD)
                    .then(function (res) {
                        var data = res.data[0];
                        $scope.cliente.codigo = res.data[0].COD;
                        $scope.cliente.NOM = data.NOM;
                        $scope.cliente.DOM = data.DOM;
                        $scope.cliente.CPO = data.CPO;
                        $scope.cliente.provincia.ID = data.PCX;
                        $scope.cliente.provincia.NOMBRE = data.PCI;
                        $scope.cliente.localidad.ID = data.LOX;
                        $scope.cliente.localidad.NOMBRE = data.LOC;
                        $scope.cliente.zona.ID = data.zona.ID;
                        $scope.cliente.zona.NOM = data.zona.NOM;
                        $scope.cliente.actividad.NOM = data.actividad.NOM;
                        $scope.cliente.actividad.ID = data.actividad.ID;
                        $scope.cliente.cobrador.NOM = data.cobrador ? data.cobrador.NOM : '';
                        $scope.cliente.cobrador.NUM = data.cobrador ? data.cobrador.NUM : undefined;
                        $scope.cliente.cobrador.ID = data.cobrador ? data.cobrador.id : undefined;
                        $scope.vendedor.NOM = data.vendedor.NOM;
                        $scope.vendedor.id = data.vendedor.id;
                        $scope.cliente.MAIL = data.MAIL;
                        $scope.cliente.TEL = data.TEL;
                        $scope.cliente.iva.NOMBRE = data.iva.NOMBRE;
                        $scope.cliente.tipoFactura.NOMBRE = data.tipoFactura.NOMBRE;
                        $scope.cliente.tipoFactura.ID = data.tipoFactura.ID;
                        var cuit = data.CUIT.split('-');
                        $scope.cliente.cuit1 = cuit[0];
                        $scope.cliente.cuit2 = cuit[1];
                        $scope.cliente.cuit3 = cuit[2];
                        $scope.cliente.tipoComprobante.NOMBRE = data.tipoComprobante.NOMBRE;
                        $scope.cliente.tipoComprobante.ID = data.tipoComprobante.ID;
                        $scope.cliente.formaPago.NOMBRE = data.formaPago.NOMBRE;
                        $scope.cliente.formaPago.ID = data.formaPago.ID;
                        $scope.cliente.ES_PROS = data.ES_PROS;
                        $scope.cliente.ES_MAY = data.ES_MAY;
                        $scope.accion = 'Editar Cliente';
                        $scope.ingreso = true;
                    })
                    .catch(function (e) { console.log(e); });
            };

            $scope.busquedaDown = function (key) {
                if (key === 40) {
                    primera(key);
                }
            };

            $scope.itemCliente = function (key) {
                if (key === 38) {
                    anterior(key);
                }

                if (key === 40) {
                    siguiente(key);
                }

                if (key === 37) {
                    retrocederPagina();
                }

                if (key === 39) {
                    avanzarPagina();
                }
            };

            $scope.focus = function (val) {
                $scope.focused = val;
            };

            //Recibe aviso si el teclado está en uso
            $rootScope.$on('usarTeclado', function (event, data) {
                if (data) {
                    $scope.mostrarTeclado = true;
                    return;
                }
                $scope.mostrarTeclado = false;
            });

            $scope.selectFocus = function ($event) {
                // Si el teclado esta en uso no selecciona el valor
                if ($scope.mostrarTeclado) {
                    return;
                }
                $event.target.select();
            };

            $scope.next = function (key) {
                if (key === 13) $scope.focused++;
            };

            $scope.seleccionarProvincia = function (key) {
                if (key === 13) {
                    var parametrosModal = {
                        searchText: $scope.cliente.provincia.NOMBRE,
                        query: '/provincia',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Codigo',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de provincias',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(function (provincia) {
                        $scope.cliente.provincia = provincia;
                        $timeout(function () {
                            $scope.focused = 4;
                        });
                    }, function () {
                        //TODO: función llamada cuando cancela el modal
                    });
                }
            };
            $scope.seleccionarLocalidad = function (key) {
                if ($scope.cliente.provincia.ID === undefined) {
                    focaModalService.alert('Seleccione una provincia');
                    return;
                }
                if (key === 13) {
                    var parametrosModal = {
                        searchText: $scope.cliente.localidad.NOMBRE,
                        query: '/localidad/' + parseInt($scope.cliente.provincia.ID),
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código',
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de localidades',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(function (localidad) {
                        $scope.cliente.localidad = localidad;
                        $timeout(function () {
                            $scope.focused = 5;
                        });
                    }, function () {
                        //TODO: función llamada cuando cancela el modal
                    });
                }
            };
            $scope.seleccionarIva = function (key) {
                if (key === 13) {
                    var parametrosModal = {
                        query: '/iva',
                        searchText: $scope.cliente.iva.NOMBRE,
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de responsabilidad ante el IVA',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function (iva) {
                            if (iva) {
                                delete $scope.cliente.tipoFactura.NOMBRE;
                            }
                            $scope.cliente.iva = iva;
                            $timeout(function () {
                                $scope.focused = 12;
                            });
                        }, function () {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarActividad = function (key) {
                if (key === 13) {
                    var parametrosModal = {
                        searchText: $scope.cliente.actividad.NOM,
                        query: '/actividad',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOM',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de actividades',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function (actividad) {
                            $scope.cliente.actividad = actividad;
                            $timeout(function () {
                                $scope.focused = 7;
                            });
                        }, function () {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarZona = function (key) {
                if (key === 13) {
                    var parametrosModal = {
                        searchText: $scope.cliente.zona.NOM,
                        query: '/zona',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOM',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de zonas',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function (zona) {
                            $scope.cliente.zona = zona;
                            $timeout(function () {
                                $scope.focused = 6;
                            });
                        }, function () {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarTipoFactura = function (key) {

                if ($scope.cliente.iva.NOMBRE === '') {
                    focaModalService.alert('Seleccione una responsabilidad ante el IVA');
                    return;
                }

                if (key === 13) {
                    var datos;
                    if ($scope.cliente.iva.ID === 1) {
                        datos = [
                            {
                                ID: 'A',
                                NOMBRE: 'Factura A'
                            },
                            {
                                ID: 'M',
                                NOMBRE: 'Factura M'
                            },
                            {
                                ID: 'R',
                                NOMBRE: 'Remito'
                            }
                        ];
                    } else {
                        datos = [
                            {
                                ID: 'B',
                                NOMBRE: 'Factura B'
                            },
                            {
                                ID: 'R',
                                NOMBRE: 'Remito'
                            }
                        ];
                    }
                    focaModalService.modal({
                        titulo: 'Seleccionar Factura',
                        data: datos,
                        size: 'md',
                        columnas: [
                            {
                                propiedad: 'ID',
                                NOMBRE: 'Codigo'
                            },
                            {
                                propiedad: 'NOMBRE',
                                NOMBRE: 'Factura'
                            }
                        ],
                    }).then(function (res) {
                        $scope.cliente.tipoFactura = res;
                    });
                }
            };
            $scope.seleccionarTipoComprobante = function (key) {
                if (key === 13) {
                    var parametrosModal = {
                        searchText: $scope.cliente.tipoComprobante.NOMBRE,
                        query: '/tipo-comprobante',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código'
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de tipos de comprobante',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function (tipoComprobante) {
                            $scope.cliente.tipoComprobante = tipoComprobante;
                            $timeout(function () {
                                $scope.focused = 17;
                            });
                        }, function () {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarFormaPago = function (key) {
                if (key === 13) {
                    var parametrosModal = {
                        searchText: $scope.cliente.formaPago.NOMBRE,
                        query: '/forma-pago',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de formas de pago',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function (formaPago) {
                            $scope.cliente.formaPago = formaPago;
                        }, function () {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarCobrador = function (key) {
                if (key === 13) {
                    var parametrosModal = {
                        searchText: $scope.cliente.cobrador.NOM,
                        query: '/cobrador',
                        columnas: [
                            {
                                propiedad: 'NUM',
                                nombre: 'Código'
                            },
                            {
                                propiedad: 'NOM',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de cobradores',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function (cobrador) {
                            $scope.cliente.cobrador = cobrador;
                        }, function () {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarVendedor = function (key) {
                if (key === 13) {
                    var parametrosModal = {
                        titulo: 'Búsqueda vendedores',
                        query: '/vendedor',
                        columnas: [
                            {
                                propiedad: 'NUM',
                                nombre: 'Código',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOM',
                                nombre: 'Nombre'
                            }
                        ],
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function (vendedor) {
                            $scope.vendedor = vendedor;
                        }, function () {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };

            $scope.pasarCampoCuit = function (numeroCuit) {
                if (numeroCuit === 1 && $scope.cliente.cuit1.length === 2) {
                    $scope.cuitActivo = 2;
                } else if (numeroCuit === 2 && $scope.cliente.cuit2.length === 8) {
                    $scope.cuitActivo = 3;
                }
            };

            $scope.guardar = function () {
                if (!$scope.cliente.NOM) {
                    focaModalService.alert('Ingrese Nombre');
                    return;
                } else if (!$scope.cliente.CPO) {
                    focaModalService.alert('Ingrese Codigo Postal');
                    return;
                } else if (!$scope.cliente.provincia.NOMBRE) {
                    focaModalService.alert('Seleccione una provincia');
                    return;
                } else if (!$scope.cliente.DOM) {
                    focaModalService.alert('Ingrese Domicilio');
                    return;
                } else if (!$scope.cliente.localidad.NOMBRE) {
                    focaModalService.alert('Seleccione una localidad');
                    return;
                } else if (!$scope.cliente.zona.NOM) {
                    focaModalService.alert('Seleccione una zona');
                    return;
                } else if (!$scope.cliente.actividad.NOM) {
                    focaModalService.alert('Seleccione actividad');
                    return;
                } else if (!$scope.cliente.cobrador.NUM) {
                    focaModalService.alert('Seleccione un cobrador');
                    return;
                } else if (!$scope.vendedor.NOM) {
                    focaModalService.alert('Seleccione un vendedor');
                    return;
                } else if ($scope.cliente.MAIL && !validateEmails($scope.cliente.MAIL)) {
                    focaModalService.alert('Ingrese un formato de email válido');
                    return;
                } else if (!$scope.cliente.TEL) {
                    focaModalService.alert('Ingrese un numero de telefono');
                    return;
                } else if (!$scope.cliente.iva.NOMBRE) {
                    focaModalService.alert('Seleccione responsabilidad ante el IVA');
                    return;
                } else if (!$scope.cliente.tipoFactura.NOMBRE) {
                    focaModalService.alert('Seleccione tipo de Factura');
                    return;
                } else if (!$scope.cliente.cuit1 && !$scope.cliente.cuit2 &&
                    !$scope.cliente.cuit3)
                {
                    focaModalService.alert('Ingrese CUIT');
                    return;
                } else if (!$scope.cliente.cuit1 || !$scope.cliente.cuit2 ||
                    !$scope.cliente.cuit3)
                {
                    focaModalService.alert('Ingrese CUIT válido');
                    return;
                } else if (!$scope.regexCuit.test($scope.cliente.cuit1 + $scope.cliente.cuit2 +
                    $scope.cliente.cuit3))
                {
                    focaModalService.alert('Ingrese CUIT con formato: XX-XXXXXXXX-X');
                    return;
                } else if (!$scope.cliente.tipoComprobante.NOMBRE) {
                    focaModalService.alert('Seleccione un Comprobante');
                    return;
                } else if (!$scope.cliente.formaPago.NOMBRE) {
                    focaModalService.alert('Seleccione una forma de pago');
                    return;
                }

                $scope.cliente.actividad.ID = parseInt($scope.cliente.actividad.ID);

                var cliente = crearCopia();

                focaBusquedaClienteService
                    .guardarCliente(cliente)
                    .then(function (res) {
                        var cliente = {
                            COD: res.data.COD,
                            cuit: res.data.CUIT,
                            esNuevo: res.data.esNuevo,
                            nom: res.data.NOM
                        };
                        $scope.select(cliente, true);
                    })
                    .catch(function (e) {
                        console.log(e);
                    });
            };

            function crearCopia() {
                var cliente = angular.copy($scope.cliente);
                cliente.COD = cliente.codigo ? cliente.codigo : 0;
                cliente.CPO = cliente.CPO;
                cliente.PCX = parseInt(cliente.provincia.ID);
                cliente.LOX = parseInt(cliente.localidad.ID);
                cliente.LOC = cliente.localidad.NOMBRE;
                cliente.PCI = cliente.provincia.NOMBRE;
                cliente.IVA = cliente.iva.ID;
                cliente.ACT = cliente.actividad.ID;
                cliente.ZON = (parseInt(cliente.zona.ID)).toString();
                cliente.TIP = cliente.tipoFactura.ID;
                cliente.TCO = cliente.tipoComprobante.ID;
                cliente.FPA = cliente.formaPago.ID;
                cliente.VEN = $scope.vendedor.id;
                cliente.CUIT = `${cliente.cuit1}-${cliente.cuit2}-${cliente.cuit3}`;
                cliente.idCobrador = cliente.cobrador.id;

                delete cliente.codigo;
                delete cliente.provincia;
                delete cliente.localidad;
                delete cliente.iva;
                delete cliente.actividad;
                delete cliente.zona;
                delete cliente.tipoFactura;
                delete cliente.tipoComprobante;
                delete cliente.formaPago;
                delete cliente.cobrador;
                delete cliente.cuit1;
                delete cliente.cuit2;
                delete cliente.cuit3;

                return cliente;
            }

            //#region PAGINADOR
            function calcularPages(paginaActual) {
                var paginas = [];
                paginas.push(paginaActual);

                if (paginaActual - 1 > 1) {

                    paginas.unshift(paginaActual - 1);
                    if (paginaActual - 2 > 1) {
                        paginas.unshift(paginaActual - 2);
                    }
                }

                if (paginaActual + 1 < $scope.lastPage) {
                    paginas.push(paginaActual + 1);
                    if (paginaActual + 2 < $scope.lastPage) {
                        paginas.push(paginaActual + 2);
                    }
                }

                if (paginaActual !== 1) {
                    paginas.unshift(1);
                }

                if (paginaActual !== $scope.lastPage) {
                    paginas.push($scope.lastPage);
                }

                return paginas;
            }

            function primera() {
                $scope.selectedClientes = 0;
            }

            function anterior() {
                if ($scope.selectedClientes === 0 && $scope.currentPage > 1) {
                    retrocederPagina();
                } else {
                    $scope.selectedClientes--;
                }
            }

            function siguiente() {
                if ($scope.selectedClientes < $scope.currentPageClientes.length - 1) {
                    $scope.selectedClientes++;
                } else {
                    avanzarPagina();
                }
            }

            function retrocederPagina() {
                if ($scope.currentPage > 1) {
                    $scope.selectPage($scope.currentPage - 1);
                    $scope.selectedClientes = $scope.numPerPage - 1;
                }
            }

            function avanzarPagina() {
                if ($scope.currentPage < $scope.lastPage) {
                    $scope.selectPage($scope.currentPage + 1);
                    $scope.selectedClientes = 0;
                }
            }
            //#endregion

            function validateEmails(emails) {
                var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
                var arr = emails.split(',');
                var result = true;
                arr.forEach(function (email) {
                    var val = String(email).trim().toLowerCase();
                    if (!re.test(val)) result = false;
                });
                return result;
            }
        }
    ]);
