angular.module('focaBusquedaCliente')
    .service('focaBusquedaClienteService', ['$http', 'API_ENDPOINT',
    function ($http, API_ENDPOINT) {
        return {
            obtenerClientesPorNombreOCuitByVendedor: function (nombreOCuit, idVendedor) {
                return $http.post(API_ENDPOINT.URL + '/cliente/listar',
                    { nombreOCuit: nombreOCuit, idVendedor: idVendedor });
            },
            obtenerClientesPorNombreOCuitByCobrador: function (nombreOCuit, idCobrador) {
                return $http.post(API_ENDPOINT.URL + '/cliente/listar',
                    { nombreOCuit: nombreOCuit, idCobrador: idCobrador });
            },
            obtenerClientesPorNombreOCuit: function (nombreOCuit) {
                return $http.post(API_ENDPOINT.URL + '/cliente/listar',
                    { nombreOCuit: nombreOCuit });
            },
            obtenerClientePorCodigo: function (cod) {
                return $http.get(API_ENDPOINT.URL + '/cliente-codigo/' + cod );
            },
            guardarCliente: function (cliente) {
                return $http.post(API_ENDPOINT.URL + '/cliente', { cliente: cliente });
            }
        };
    }]);
