const templateCache = require('gulp-angular-templatecache');
const clean         = require('gulp-clean');
const concat        = require('gulp-concat');
const htmlmin       = require('gulp-htmlmin');
const rename        = require('gulp-rename');
const uglify        = require('gulp-uglify');
const gulp          = require('gulp');
const pump          = require('pump');
const jshint        = require('gulp-jshint');
const replace       = require('gulp-replace');
const connect       = require('gulp-connect');
const header        = require('gulp-header');
const footer        = require('gulp-footer');
const gulpSequence  = require('gulp-sequence');

var paths = {
    srcJS:    'src/js/*.js',
    srcViews: 'src/views/*.html',
    specs:    'spec/*.js',
    tmp:      'tmp',
    dist:     'dist/'
};

gulp.task('uglify', function(callback) {
    gulpSequence('clean', ['templates'], 'uglify-app')(callback);
});

gulp.task('templates', function() {
    return pump(
        [
            gulp.src(paths.srcViews),
            htmlmin(),
            templateCache('views.js', {
                module: 'focaCrearFactura',
                root: ''
            }),
            gulp.dest(paths.tmp)
        ]
    );
});

gulp.task('uglify-app', function() {
    return pump(
        [
            gulp.src([
                paths.srcJS,
                'tmp/views.js'
            ]),
            concat('foca-crear-factura.js'),
            replace('src/views/', ''),
            gulp.dest(paths.tmp),
            rename('foca-crear-factura.min.js'),
            uglify(),
            gulp.dest(paths.dist)
        ]
    );
});

gulp.task('uglify-spec', function() {
    return pump(
        [
            gulp.src(paths.specs),
            concat('foca-crear-factura.spec.js'),
            replace('src/views/', ''),
            header("describe('Módulo foca-crear-factura', function() { \n"),
            footer("});"),
            gulp.dest(paths.dist)
        ]
    );
});

gulp.task('clean', function() {
    return gulp.src(['tmp', 'dist'], {read: false}).pipe(clean());
});

gulp.task('pre-commit', function() {
    return pump(
        [
            gulp.src([paths.srcJS, paths.specs]),
            jshint('.jshintrc'),
            jshint.reporter('default'),
            jshint.reporter('fail')
        ]
    );

    gulp.start('uglify');
});

gulp.task('webserver', function() {
    pump [
        connect.server({port: 3300, host: '0.0.0.0'})
    ]
});

gulp.task('clean-post-install', function() {
    return gulp.src(['src', 'tmp', '.jshintrc','readme.md', '.gitignore', 'gulpfile.js',
                     'index.html'], {read: false})
    .pipe(clean());
});

gulp.task('default', ['webserver']);

gulp.task('watch', function() {
    gulp.watch([paths.srcJS, paths.srcViews], ['uglify']);
});

gulp.task('copy', ['uglify'], function() {
    return gulp.src('dist/*.js')
        .pipe(gulp.dest('../../wrapper-demo/node_modules/foca-crear-remito/dist/'));
});

gulp.task('watchAndCopy', function() {
    return gulp.watch([paths.srcJS, paths.srcViews], ['copy']);
});
