angular.module('focaCrearFactura')
    .controller('focaModalCombustiblesController', [
        '$filter',
        '$scope',
        '$uibModalInstance',
        'parametros',
        function ($filter, $scope, $uibModalInstance, parametros) {

            $scope.mangueras = [];
            $scope.colorTexto = { color: 'black' };
            var productosByMangera = [];

            config();

            function config() {

                $scope.nombreProducto = parametros.nombreProducto;
                setColorNombreProducto();
                parametros.despachos.forEach(function (despacho) {

                    var findCsu = productosByMangera.filter(function (csu) {
                        return csu.csu === despacho.CSU.trim();
                    })[0];

                    if (!findCsu) {

                        var mangera = {
                            csu: despacho.CSU.trim(),
                            despachos: [despacho],
                            show: true
                        };

                        productosByMangera.unshift(mangera);
                    } else {
                        findCsu.despachos.push(despacho);
                    }
                });
            }

            $scope.mangueras = productosByMangera;

            $scope.mangueras.forEach(function (producto) {

                producto.despachos.splice(parametros.topDespachos, producto.despachos.length);

                producto.despachos.sort(function (a, b) {
                    return a.FEC - b.FEC;
                });
            });

            $scope.aceptar = function (despacho) {
                $uibModalInstance.close(despacho);
            };

            $scope.cancel = function () {
                $uibModalInstance.dismiss('cancel');
            };

            //TODO: Cambiar switch case con los casos de nombres de productos axion
            function setColorNombreProducto() {

                // Diesel #FF852E | Euro+Diesel #6C389A | Premium #00A857 | Super #175AA5
                switch ($scope.nombreProducto) {
                    case 'NAFTA SUPER XXI':
                        $scope.colorTexto = { color: '#FF852E' };
                        break;
                    case 'GO-INFINIA DIESEL':
                        $scope.colorTexto = { color: '#6C389A' };
                        break;
                    case 'ULTRADIESEL XXI - RED':
                        $scope.colorTexto = { color: '#00A857' };
                        break;
                    case 'NAFTA INFINIA':
                        $scope.colorTexto = { color: '#175AA5' };
                        break;
                    default:
                        $scope.colorTexto = { color: 'black' };
                        break;
                }
            }
        }
    ]);
