angular.module('focaCrearFactura')
    .controller('focaModalEstadoCuentaController', [
        '$scope', '$uibModalInstance', 'crearFacturaService', 'parametros',
        function ($scope, $uibModalInstance, crearFacturaService, parametros) {

            $scope.estadoCuenta = {
                autorizado: 0.0,
                extracciones: 0.0,
                saldo: 0.0,
                situacion: false,
                facturasVencidas: 0.0
            };
            $scope.cliente = parametros;

            init();

            function init() {

                crearFacturaService.getResumenCuenta(parametros.idCliente)
                    .then(function (res) {
                        $scope.estadoCuenta = res.data[0];
                        if ($scope.estadoCuenta.saldo > 0) {
                            $scope.estadoCuenta.situacion = true;
                        } else {
                            $scope.estadoCuenta.situacion = false;
                        }
                    })
                    .catch(function (e) { console.error(e); });
            }

            $scope.elegirTipoDePago = function (tipoDePago) {
                $uibModalInstance.close(tipoDePago);
            };

            $scope.cancel = function () {
                $uibModalInstance.dismiss('cancel');
            };
        }
    ]);
