angular.module('focaCrearFactura')
    .controller('ultimosDespachosController', [
        '$filter',
        '$scope',
        '$uibModalInstance',
        'crearFacturaService',
        'parametros',
        function ($filter, $scope, $uibModalInstance, crearFacturaService, parametros) {

            config();

            function config() {

                $scope.productos = [];

                crearFacturaService.getUltimosDespachos(parametros.planilla).then(function (res) {

                    res.data.slice(1, res.data.length).forEach(function (producto) {

                        producto.mangueras = [];

                        producto.despachos.forEach(function (despacho) {

                            var findCsu = producto.mangueras.filter(function (csu) {
                                return csu.csu === despacho.CSU.trim();
                            })[0];

                            if (!findCsu) {

                                var manguera = {
                                    csu: despacho.CSU.trim(),
                                    despachos: [despacho],
                                    show: true
                                };

                                producto.mangueras.unshift(manguera);
                            } else {
                                findCsu.despachos.push(despacho);
                            }
                        });

                        $scope.productos.push(producto);
                    });

                    console.log($scope.productos);

                });
            }

            $scope.aceptar = function (producto, despacho) {
                producto.despachos = [];
                producto.despachos.push(despacho);
                $uibModalInstance.close(producto);
            };

            $scope.cancel = function () {
                $uibModalInstance.dismiss('cancel');
            };

        }
    ]);
