angular.module('focaCrearFactura')
    .service('crearFacturaService', ['$http', 'API_ENDPOINT', 'APP',
        function ($http, API_ENDPOINT, APP) {
            var route = API_ENDPOINT.URL;
            return {
                guardarFactura: function (factura) {
                    return $http.post(route + '/factura/guardar', factura);
                },
                getParametros: function () {
                    return $http.get(API_ENDPOINT.URL + '/parametros/factura');
                },
                validarPlanillaVendedor: function (idVendedor) {
                    return $http.get(route + '/turnos/validar-planilla/' + idVendedor);
                },
                getProductosByPlanilla: function (numeroPlanilla) {
                    return $http.get(route + '/turnos/productos/' + numeroPlanilla);
                },
                getUltimosDespachos: function (numeroPlanilla) {
                    return $http.get(route + '/turnos/productos/' + numeroPlanilla + '/true');
                },
                setearDespachoOcupado: function (parametros) {
                    return $http.post(route + '/turnos/despacho-en-uso', parametros);
                },
                setearDespachoDesocupado: function (parametros) {
                    return $http.post(route + '/turnos/depacho-sin-uso', parametros);
                },
                getResumenCuenta: function (idCliente) {
                    return $http.get(route + '/cliente/resumen-cuenta/' + idCliente);
                },
                getVendedorPlayaById: function (id) {
                    return $http.get(route + '/vendedor-playa/' + id);
                },
                getBotonera: function () {
                    var vendedor = {
                        label: 'Vendedor',
                        image: 'vendedor.png'
                    };
                    // $scope.botoneraProductos.push({
                    //     label: 'Busqueda Productos',
                    //     image: 'buscarProductos.png',
                    //     imageDefault: 'productoDefault.png'
                    // });
                    var botones = [
                        {
                            label: 'Cliente',
                            image: 'cliente.png'
                        },
                        {
                            label: 'Búsqueda Productos',
                            image: 'productos.png'
                        }
                        // {
                        //     label: 'Moneda',
                        //     image: 'moneda.png'
                        // },
                        // {
                        //     label: 'Observaciones',
                        //     image: 'botonObservaciones.png'
                        // }
                    ];

                    if (APP !== 'facturador') {
                        botones.unshift(vendedor);
                    }

                    return botones;
                }
            };
        }
    ]);
