describe('Controlador modulo crear remito', function() {

    var $controller;

    beforeEach(function() {

        module('focaCrearRemito');

        inject(function(_$controller_) {
            $controller = _$controller_;
        });
    });

    describe('Controlador remitoController', function() {

        var timeout;

        beforeEach(function() {

            inject(function($timeout) {
                timeout = $timeout;
            });
        });

        it('Existe el controlador remitoController', function() {

            //act
            var controlador = $controller('remitoController', {
                $scope: {
                    $broadcast: function() { },
                    $watch: function() { }
                },
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() { },
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {},
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
           });

           //assert
           expect(typeof controlador).toEqual('object');

        });

        it('seleccionarNotaPedido levanta modal', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var uibModal = {
                open: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: uibModal,
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() { },
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {},
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
           });

           //act
           spyOn(uibModal, 'open').and.returnValue({ result: { then: function() { } } });
           spyOn(scope, 'seleccionarNotaPedido');
           scope.seleccionarNotaPedido();

           //assert
           expect(scope.seleccionarNotaPedido).toHaveBeenCalled();

        });

        it('seleccionarRemito levanta modal', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var uibModal = {
                open: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: uibModal,
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() { },
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {},
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
           });

           //act
           spyOn(uibModal, 'open').and.returnValue({ result: { then: function() { } } });
           spyOn(scope, 'seleccionarRemito');
           scope.seleccionarRemito();

           //assert
           expect(scope.seleccionarRemito).toHaveBeenCalled();

        });

        it('crearRemito muestra alerta cuando no se eligió vendedor', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                alert: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() { },
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {},
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
           });

           //act
           spyOn(focaModalService, 'alert');
           scope.crearRemito();

           //assert
           expect(focaModalService.alert).toHaveBeenCalledWith('Ingrese Vendedor');

        });

        it('crearRemito muestra alerta cuando no se eligió cliente', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                alert: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() { },
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {},
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
           });

           scope.remito = {
               vendedor: { NUM: true },
               cliente: {}
           };

           //act
           spyOn(focaModalService, 'alert');
           scope.crearRemito();

           //assert
           expect(focaModalService.alert).toHaveBeenCalledWith('Ingrese Cliente');

        });

        it('crearRemito muestra alerta cuando no se eligió Proveedor', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                alert: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() { },
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {},
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
           });

           scope.remito = {
               vendedor: { NUM: true },
               cliente: { COD: true }
           };

           //act
           spyOn(focaModalService, 'alert');
           scope.crearRemito();

           //assert
           expect(focaModalService.alert).toHaveBeenCalledWith('Ingrese Proveedor');

        });

        it('crearRemito muestra alerta cuando no se eligió moneda', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                alert: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() { },
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {},
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
           });

           scope.remito = {
               vendedor: { NUM: true },
               cliente: { COD: true },
               proveedor: {},
               cotizacion: { moneda: {} }
           };

           //act
           spyOn(focaModalService, 'alert');
           scope.crearRemito();

           //assert
           expect(focaModalService.alert).toHaveBeenCalledWith('Ingrese Moneda');

        });

        it('crearRemito muestra alerta cuando no se eligió Cotización', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                alert: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() { },
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {},
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
           });

           scope.remito = {
               vendedor: { NUM: true },
               cliente: { COD: true },
               proveedor: {},
               cotizacion: { moneda: { id: true } }
           };

           //act
           spyOn(focaModalService, 'alert');
           scope.crearRemito();

           //assert
           expect(focaModalService.alert).toHaveBeenCalledWith('Ingrese Cotización');

        });

        it('crearRemito muestra alerta cuando no se eligió flete', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                alert: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() { },
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {},
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
           });

           scope.remito = {
                vendedor: { NUM: true },
                cliente: { COD: true },
                proveedor: {},
                cotizacion: {
                   moneda: { id: true },
                   ID: true
                }
           };

           //act
           spyOn(focaModalService, 'alert');
           scope.crearRemito();

           //assert
           expect(focaModalService.alert).toHaveBeenCalledWith('Ingrese Flete');

        });

        it('crearRemito muestra alerta cuando no se eligió articulos', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                alert: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() { },
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {},
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
           });

           scope.remito = {
                vendedor: { NUM: true },
                cliente: { COD: true },
                proveedor: {},
                cotizacion: {
                   moneda: { id: true },
                   ID: true
                },
                flete: true,
                articulosRemito: []
           };

           //act
           spyOn(focaModalService, 'alert');
           scope.crearRemito();

           //assert
           expect(focaModalService.alert).toHaveBeenCalledWith('Debe cargar al menos un articulo');

        });

        it('crearRemito llama a startGuardar', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaBotoneraLateralService = {
                startGuardar: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() { },
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() { }
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() { }
                        };
                    },
                    crearRemito: function() {
                        return {
                            then: function() { }
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {},
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: focaBotoneraLateralService,
                $localStorage: {}
           });

           scope.remito = {
                vendedor: { NUM: true },
                cliente: { COD: true },
                proveedor: {},
                cotizacion: {
                   moneda: { id: true },
                   ID: true
                },
                flete: true,
                articulosRemito: [ 1 ]
           };

           //act
           spyOn(focaBotoneraLateralService, 'startGuardar');
           scope.crearRemito();

           //assert
           expect(focaBotoneraLateralService.startGuardar).toHaveBeenCalled();

        });

        it('crearRemito llama a endGuardar y abre modal', function(done) {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaBotoneraLateralService = {
                startGuardar: function() { },
                endGuardar: function() { }
            };
            var uibModal = {
                open: function() { }
            };
            var crearRemitoService = {
                getBotonera: function() { },
                getCotizacionByIdMoneda: function() {
                    return {
                        then: function() { }
                    };
                },
                getNumeroRemito: function() {
                    return {
                        then: function() { }
                    };
                },
                crearRemito: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: uibModal,
                $location: {},
                $filter: {},
                crearRemitoService: crearRemitoService,
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: focaBotoneraLateralService,
                $localStorage: {}
            });

            scope.remito = {
                vendedor: { NUM: true },
                cliente: { COD: true },
                proveedor: {},
                cotizacion: {
                    moneda: { id: true },
                    ID: true
                },
                flete: true,
                articulosRemito: [1]
            };
            var promiseRespond = Promise.resolve({ data: {} });

            //act
            spyOn(crearRemitoService, 'crearRemito').and.returnValue(promiseRespond);
            spyOn(focaBotoneraLateralService, 'endGuardar');
            spyOn(uibModal, 'open');
            scope.crearRemito();

            //assert
            promiseRespond.then(function() {

                expect(focaBotoneraLateralService.endGuardar).toHaveBeenCalled();
                done();
            });
        });

        it('seleccionarProductos abre modal', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var uibModal = {
                open: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: uibModal,
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });

            scope.remito = {
                cotizacion: {
                    moneda: { },
                },
            };
            scope.idLista = true;

            //act
            spyOn(uibModal, 'open').and.returnValue({ result: { then: function() {} } });
            scope.seleccionarProductos();

            //assert
            expect(uibModal.open).toHaveBeenCalled();
        });

        it('seleccionarProductos abre alerta si no se eligió lista', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                alert: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });

            //act
            spyOn(focaModalService, 'alert');
            scope.seleccionarProductos();

            //assert
            expect(focaModalService.alert)
                .toHaveBeenCalledWith('Primero seleccione una lista de precio y condicion');
        });

        it('seleccionarPuntosDeDescarga abre modal', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var uibModal = {
                open: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: uibModal,
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });
            scope.remito = {
                cliente: { COD: true },
                domicilio: { id: true }
            };

            //act
            spyOn(uibModal, 'open').and.returnValue({ result: { then: function() { } } });
            scope.seleccionarPuntosDeDescarga();

            //assert
            expect(uibModal.open).toHaveBeenCalled();
        });

        it('seleccionarVendedor abre modal', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                modal: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });

            //act
            spyOn(focaModalService, 'modal').and.returnValue({ then: function() { } });
            scope.seleccionarVendedor();

            //assert
            expect(focaModalService.modal).toHaveBeenCalled();
        });

        it('seleccionarCliente abre modal', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var uibModal = {
                open: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: uibModal,
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });

            //act
            spyOn(uibModal, 'open').and.returnValue({ result: { then: function() { } } });
            scope.seleccionarCliente(true);

            //assert
            expect(uibModal.open).toHaveBeenCalled();
        });

        it('seleccionarCliente setea cliente y llama a abrirModalDomicilios', function(done) {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var uibModal = {
                open: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: uibModal,
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });
            var response = 'test';
            var promesa = { result: Promise.resolve(response) };

            //act
            spyOn(uibModal, 'open').and.returnValue(promesa);
            spyOn(scope, 'abrirModalDomicilios');
            scope.seleccionarCliente(true);

            //assert
            promesa.result.then(function() {
                expect(scope.abrirModalDomicilios).toHaveBeenCalledWith(response);
                expect(scope.cliente).toEqual(response);
                done();
            });
        });

        it('seleccionarProveedor abre modal', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                modal: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });

            //act
            spyOn(focaModalService, 'modal').and.returnValue({ then: function() { } });
            scope.seleccionarProveedor();

            //assert
            expect(focaModalService.modal).toHaveBeenCalled();
        });

        it('seleccionarProveedor setea provedor y llama a callback', function(done) {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                modal: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: function() {
                    return function() { };
                },
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });
            var response = { COD: 1 };
            var promesa = Promise.resolve(response);
            window.callback = function() { };

            //act
            spyOn(focaModalService, 'modal').and.returnValue(promesa);
            spyOn(window, 'callback');
            scope.seleccionarProveedor(window.callback);

            //assert
            promesa.then(function() {
                expect(window.callback).toHaveBeenCalled();
                expect(scope.remito.proveedor).toBe(response);
                expect(scope.remito.idProveedor).toBe(response.COD);
                done();
            });
        });

        it('abrirModalDomicilios abre modal', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var uibModal = {
                open: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: uibModal,
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });

            //act
            spyOn(uibModal, 'open').and.returnValue({ result: { then: function() { } } });
            scope.abrirModalDomicilios();

            //assert
            expect(uibModal.open).toHaveBeenCalled();

        });

        it('getTotal devuelve correctamente', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });
            scope.remito = {
                articulosRemito: [
                    {
                        precio: 100,
                        cantidad: 3
                    }
                ]
            };

            //act
            var result = scope.getTotal();

            //assert
            expect(result).toEqual(300);

        });

        it('getSubTotal devuelve correctamente', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });
            scope.articuloACargar = {
                precio: 200,
                cantidad: 4
            };

            //act
            var result = scope.getSubTotal();

            //assert
            expect(result).toEqual(800);

        });

        it('seleccionarPreciosYCondiciones muestra alerta sino se eligió cliente', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                alert: function() {}
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });

            //act
            spyOn(focaModalService, 'alert');
            scope.seleccionarPreciosYCondiciones();

            //assert
            expect(focaModalService.alert).toHaveBeenCalledWith('Primero seleccione un cliente');

        });

        it('seleccionarPreciosYCondiciones abre modal', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var uibModal = {
                open: function() {}
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: uibModal,
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });
            scope.remito = {
                cliente: { COD: true }
            };

            //act
            spyOn(uibModal, 'open').and.returnValue({ result: { then: function() { } } });
            scope.seleccionarPreciosYCondiciones();

            //assert
            expect(uibModal.open).toHaveBeenCalled();

        });

        it('seleccionarMoneda abre modal y llama a cotizacion', function(done) {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                modal: function() {}
            };
            var uibModal = {
                open: function() {
                    return {
                        result: {
                            then: function() {}
                        }
                    };
                }
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: uibModal,
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });
            var promesa = Promise.resolve('test');

            //act
            spyOn(focaModalService, 'modal').and.returnValue(promesa);
            scope.seleccionarMoneda();

            //assert
            promesa.then(function() {
                expect(focaModalService.modal).toHaveBeenCalled();
                done();
            });
        });

        it('seleccionarObservaciones levanta prompt', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var focaModalService = {
                prompt: function() {}
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: {},
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: focaModalService,
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });

            //act
            spyOn(focaModalService, 'prompt').and.returnValue({ then: function() { } });
            scope.seleccionarObservaciones();

            //assert
            expect(focaModalService.prompt).toHaveBeenCalled();
        });

        it('abrirModalCotizacion abre modal', function() {

            //arrange
            var scope = {
                $broadcast: function() { },
                $watch: function() { }
            };
            var uibModal = {
                open: function() {}
            };

            $controller('remitoController', {
                $scope: scope,
                $uibModal: uibModal,
                $location: {},
                $filter: {},
                crearRemitoService: {
                    getBotonera: function() {},
                    getCotizacionByIdMoneda: function() {
                        return {
                            then: function() {}
                        };
                    },
                    getNumeroRemito: function() {
                        return {
                            then: function() {}
                        };
                    }
                },
                $timeout: timeout,
                focaModalService: {},
                remitoBusinessService: {
                    addArticulos: function() { }
                },
                $rootScope: {
                    $on: function() { }
                },
                focaBotoneraLateralService: {},
                $localStorage: {}
            });

            //act
            spyOn(uibModal, 'open').and.returnValue({ result: { then: function() { } } });
            scope.abrirModalCotizacion();

            //assert
            expect(uibModal.open).toHaveBeenCalled();
        });
    });
});
