describe('Servicios modulo crear remito', function() {

    beforeEach(function(){
        module('focaCrearRemito');
        inject(module(function($provide) {
            $provide.value('API_ENDPOINT', {
                URL: 'localhost'
            });
        }));
    });

    describe('servicio crearRemitoService', function() {

        var servicio, httpBackend;

        beforeEach(function() {
            inject(function($httpBackend, _crearRemitoService_) {
                servicio = _crearRemitoService_;
                httpBackend = $httpBackend;
            });
        });

        it('existe el servicio crearRemitoService', function() {

            //assert
            expect(typeof servicio).toEqual('object');
        });

        it('función crearRemito llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectPOST('localhost/remito', fakeParam).respond(respond);

            //act
            servicio.crearRemito(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función getRemitoById llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectGET('localhost/remito/obtener/' + fakeParam).respond(respond);

            //act
            servicio.getRemitoById(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función obtenerRemito llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectGET('localhost/nota-pedido').respond(respond);

            //act
            servicio.obtenerRemito(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función setRemito setea correctamente', function() {

            //arrange
            var fakeParam = 1;

            //act
            servicio.setRemito(fakeParam);

            //assert
            expect(servicio.remito).toEqual(fakeParam);
        });

        it('función clearRemito setea correctamente', function() {

            //act
            servicio.clearRemito();

            //assert
            expect(servicio.remito).toEqual(undefined);
        });

        it('función getRemito trae correctamente', function() {

            //arrange
            var fakeParam = 1;

            //act
            servicio.remito = fakeParam;
            var result = servicio.getRemito();

            //assert
            expect(result).toEqual(fakeParam);
        });

        it('función getArticulosByIdRemito llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectGET('localhost/articulos/nota-pedido/' + fakeParam).respond(respond);

            //act
            servicio.getArticulosByIdRemito(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función crearArticulosParaRemito llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectPOST('localhost/articulos/remito', {articuloRemito: fakeParam})
                .respond(respond);

            //act
            servicio.crearArticulosParaRemito(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función getDomiciliosByIdRemito llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectGET('localhost/nota-pedido/' + fakeParam + '/domicilios')
                .respond(respond);

            //act
            servicio.getDomiciliosByIdRemito(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función getDomiciliosByIdCliente llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectGET('localhost/domicilio/tipo/2/cliente/' + fakeParam)
                .respond(respond);

            //act
            servicio.getDomiciliosByIdCliente(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función getPrecioCondicion llama a ruta correcta', function() {

            //arrange
            var result;
            var respond = 'test';
            httpBackend.expectGET('localhost/precio-condicion').respond(respond);

            //act
            servicio.getPrecioCondicion().then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función getPrecioCondicionById llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectGET('localhost/precio-condicion/' + fakeParam).respond(respond);

            //act
            servicio.getPrecioCondicionById(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función getPlazoPagoByPrecioCondicion llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectGET('localhost/plazo-pago/precio-condicion/' + fakeParam)
                .respond(respond);

            //act
            servicio.getPlazoPagoByPrecioCondicion(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función crearFlete llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectPOST('localhost/flete', {flete: fakeParam}).respond(respond);

            //act
            servicio.crearFlete(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función crearPlazosParaRemito llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectPOST('localhost/plazo-pago/remito', fakeParam).respond(respond);

            //act
            servicio.crearPlazosParaRemito(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función getCotizacionByIdMoneda llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectGET('localhost/moneda/' + fakeParam).respond(respond);

            //act
            servicio.getCotizacionByIdMoneda(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función crearEstadoParaRemito llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectPOST('localhost/estado', { estado: fakeParam }).respond(respond);

            //act
            servicio.crearEstadoParaRemito(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función getNumeroRemito llama a ruta correcta', function() {

            //arrange
            var result;
            var respond = 'test';
            httpBackend.expectGET('localhost/remito/numero-siguiente').respond(respond);

            //act
            servicio.getNumeroRemito().then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función imprimirRemitoByIdRemito llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = new Blob(['test']);
            httpBackend.expectGET('localhost/remito/comprobante/' + fakeParam)
                .respond(respond);

            //act
            servicio.imprimirRemitoByIdRemito(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función getPuntosDescargaByClienDom llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectGET('localhost/punto-descarga/' + fakeParam + '/' + fakeParam)
                .respond(respond);

            //act
            servicio.getPuntosDescargaByClienDom(fakeParam, fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });

        it('función enviarCorreo llama a ruta correcta', function() {

            //arrange
            var result;
            var fakeParam = 1;
            var respond = 'test';
            httpBackend.expectPOST('localhost/remito/mail', fakeParam)
                .respond(respond);

            //act
            servicio.enviarCorreo(fakeParam).then(function(res) {
                result = res.data;
            });
            httpBackend.flush();

            //assert
            expect(result).toEqual(respond);
        });
    });
});
