angular.module('focaCrearRemito')
    .factory('remitoBusinessService', ['crearRemitoService', 'focaModalService',
        function(crearRemitoService, focaModalService) {
        return {
            quitarCotizacion: function(articulosRemito, cotizacion) {

                for(var i = 0; i < articulosRemito.length; i++) {

                    delete articulosRemito[i].editCantidad;
                    delete articulosRemito[i].editPrecio;
                    delete articulosRemito[i].idNotaPedido;

                    articulosRemito[i].precio = articulosRemito[i].precio * cotizacion;
                }

                return articulosRemito;

            },
            addEstado: function(idRemito) {
                var date = new Date();
                var estado = {
                    idRemito: idRemito,
                    fecha: new Date(date.getTime() - (date.getTimezoneOffset() * 60000))
                        .toISOString().slice(0, 19).replace('T', ' '),
                    estado: 0,
                    // idVendedor: idVendedor
                };
                crearRemitoService.crearEstadoParaRemito(estado);
            },
            calcularArticulos: function(articulos, cotizacion) {
                for(var i = 0; i < articulos.length; i++) {
                    articulos[i].precio = articulos[i].precio / cotizacion;
                }
            },
            plazoToString: function(plazos) {
                var result = '';
                for(var i = 0; i < plazos.length; i++) {
                    result += plazos[i].dias + ' ';
                }
                return result.trim();
            },
            addPuntosDescarga: function(puntosDescarga) {

                var puntos = [];

                puntosDescarga.forEach(function(punto) {
                    puntos.push({
                        idPuntoDescarga: punto.puntoDescarga.id,
                    });
                });

                return puntos;
            },
            validarRemito: function (remito, articulos) {

                // if (!remito.vendedor.NUM) {
                //     focaModalService.alert('Ingrese Vendedor');
                //     return false;
                if (!remito.cliente.COD) {
                    focaModalService.alert('Ingrese Cliente');
                    return false;
                } else if (!remito.proveedor.COD) {
                    focaModalService.alert('Ingrese Proveedor');
                    return false;
                } else if (!remito.cotizacion.moneda.id &&
                    !remito.cotizacion.moneda.ID) {
                    focaModalService.alert('Ingrese Moneda');
                    return false;
                } else if (!remito.cotizacion.ID) {
                    focaModalService.alert('Ingrese Cotización');
                    return false;
                } else if (remito.flete === undefined || remito.flete === null) {
                    focaModalService.alert('Ingrese Flete');
                    return false;
                } else if (articulos.length === 0) {
                    focaModalService.alert('Debe cargar al menos un articulo');
                    return false;
                }

                return true;
            }
        };
    }]);
