angular.module('focaCrearRemito').controller('remitoController',
    [
        '$scope', '$uibModal', '$location', '$filter', 'crearRemitoService', '$timeout',
        'focaModalService', 'remitoBusinessService', '$rootScope', 'focaBotoneraLateralService',
        '$localStorage',
        function (
            $scope, $uibModal, $location, $filter, crearRemitoService, $timeout, focaModalService,
            remitoBusinessService, $rootScope, focaBotoneraLateralService, $localStorage) {
            config();

            var cotizacionPArgentino = {};

            function config() {
                $scope.tmpCantidad = Number;
                $scope.tmpPrecio = Number;
                $scope.botonera = crearRemitoService.getBotonera();
                $scope.isNumber = angular.isNumber;
                $scope.datepickerAbierto = false;
                $scope.show = false;
                $scope.cargando = true;
                $scope.now = new Date();
                $scope.puntoVenta = rellenar(0, 4);
                $scope.comprobante = rellenar(0, 8);
                $scope.dateOptions = {
                    maxDate: new Date(),
                    minDate: new Date(2010, 0, 1)
                };
                $scope.cabeceras = [];
                crearRemitoService.getParametros().then(function (res) {
                    var parametros = JSON.parse(res.data[0].jsonText);
                    if ($localStorage.remito) {
                        $timeout(function () { getLSRemito(); });
                    } else {
                        for (var property in parametros) {
                            $scope.remito[property] = parametros[property];
                            $scope.inicial[property] = parametros[property];
                        }
                        setearRemito($scope.remito);
                    }
                });

                //SETEO BOTONERA LATERAL
                $timeout(function () {
                    focaBotoneraLateralService.showSalir(false);
                    focaBotoneraLateralService.showPausar(true);
                    focaBotoneraLateralService.showGuardar(true, $scope.crearRemito);
                    focaBotoneraLateralService.addCustomButton('Salir', salir);
                });

                init();
            }

            function init() {
                $scope.$broadcast('cleanCabecera');
                $scope.remito = {
                    id: 0,
                    estado: 0,
                    // vendedor: {},
                    cliente: {},
                    proveedor: {},
                    domicilio: { dom: '' },
                    moneda: {},
                    cotizacion: $scope.cotizacionPorDefecto || {},
                    articulosRemito: [],
                    remitoPuntoDescarga: []
                };
                $scope.notaPedido = {
                    id: 0
                };

                $scope.remito.articulosRemito = [];
                $scope.idLista = undefined;

                crearRemitoService.getNumeroRemito().then(
                    function (res) {
                        $scope.puntoVenta = rellenar(res.data.sucursal, 4);
                        $scope.comprobante = rellenar(res.data.numeroRemito, 8);
                    },
                    function (err) {
                        focaModalService.alert('La terminal no esta configurada correctamente');
                        console.info(err);
                    }
                );

                $scope.inicial = angular.copy($scope.remito);
            }

            $scope.$watch('remito', function (newValue) {
                focaBotoneraLateralService.setPausarData({
                    label: 'remito',
                    val: newValue
                });
                focaBotoneraLateralService.setRutasPausadas({
                    label: 'rutas',
                    val: 'venta-remito/crear'
                });
            }, true);

            $scope.seleccionarNotaPedido = function () {
                if ($scope.remitoIsDirty) {
                    focaModalService.confirm('¿Desea continuar? Se perderan los cambios')
                        .then(function () {
                            $scope.getNotaPedidoModal();
                        });
                } else {
                    $scope.getNotaPedidoModal();
                }
            };

            $scope.getNotaPedidoModal = function () {
                if (!varlidarRemitoFacturado()) return;
                if (!varlidarRemitoAbierto()) return;
                var modalInstance = $uibModal.open(
                    {
                        ariaLabelledBy: 'Busqueda de Nota de Pedido',
                        templateUrl: 'foca-modal-nota-pedido.html',
                        controller: 'focaModalNotaPedidoController',
                        size: 'lg',
                        resolve: {
                            usadoPor: function () { return 'remito'; },
                            idVendedor: function () { return null; }
                        }
                    }
                );
                modalInstance.result.then(
                    function (notaPedido) {
                        //añado cabeceras
                        $scope.remitoIsDirty = true;
                        $scope.notaPedido = notaPedido;
                        $scope.remito.cliente = notaPedido.cliente;
                        $scope.$broadcast('removeCabecera', 'Bomba:');
                        $scope.$broadcast('removeCabecera', 'Kilometros:');
                        var puntosDescarga = [];
                        notaPedido.notaPedidoPuntoDescarga.forEach(function (notaPedido) {
                            puntosDescarga.push(notaPedido.puntoDescarga);
                        });
                        $scope.cabeceras = [
                            {
                                label: 'Cliente:',
                                valor: $filter('rellenarDigitos')(notaPedido.cliente.COD, 3) +
                                    ' - ' + notaPedido.cliente.NOM
                            },
                            {
                                label: 'Domicilio:',
                                valor: notaPedido.domicilioStamp
                            },
                            // {
                            //     label: 'Vendedor:',
                            //     valor: $filter('rellenarDigitos')(
                            //         notaPedido.vendedor.NUM, 3
                            //     ) + ' - ' + notaPedido.vendedor.NOM
                            // },

                            {
                                label: 'Proveedor:',
                                valor: $filter('rellenarDigitos')
                                    (notaPedido.proveedor.COD, 5) + ' - ' +
                                    notaPedido.proveedor.NOM
                            },

                            {
                                label: 'Flete:',
                                valor: notaPedido.fob === 1 ? 'FOB' : (
                                    notaPedido.flete === 1 ? 'Si' : 'No')
                            },
                            {
                                label: 'Puntos de descarga: ',
                                valor: $filter('rellenarDigitos')(
                                    getCabeceraPuntoDescarga(puntosDescarga))
                            }
                        ];
                        actualizarCabeceraMoneda(notaPedido.cotizacion);
                        valorPrecioCondicion();
                        // Seteo checked en cabeceras
                        $filter('filter')($scope.botonera,
                            { label: 'Cliente' })[0].checked = true;
                        $filter('filter')($scope.botonera,
                            { label: 'Proveedor' })[0].checked = true;
                        $filter('filter')($scope.botonera,
                            { label: 'Moneda' })[0].checked = true;
                        $filter('filter')($scope.botonera,
                            { label: 'Nota pedido' })[0].checked = true;
                        $filter('filter')($scope.botonera,
                            { label: 'Precios y condiciones' })[0].checked = true;
                        $filter('filter')($scope.botonera,
                            { label: 'Domicilio de Entrega' })[0].checked = true;

                        if (notaPedido.observaciones) {
                            $filter('filter')($scope.botonera,
                                { label: 'Observaciones' })[0].checked = true;
                        }

                        function valorPrecioCondicion() {
                            if (parseInt(notaPedido.idListaPrecio) > 0) {
                                crearRemitoService
                                    .getListaPrecioById(parseInt(notaPedido.idListaPrecio))
                                    .then(function (res) {
                                        $scope.cabeceras.push({
                                            label: 'Precios y Condiciones:',
                                            valor:
                                                parseInt(res.data[0].ID) + ' - ' +
                                                res.data[0].DES + ' ' +
                                                remitoBusinessService
                                                    .plazoToString(notaPedido.notaPedidoPlazo)
                                        });
                                        addArrayCabecera($scope.cabeceras);
                                    });
                            }
                        }

                        if (notaPedido.flete === 1) {
                            var cabeceraBomba = {
                                label: 'Bomba:',
                                valor: notaPedido.bomba === 1 ? 'Si' : 'No'
                            };
                            if (notaPedido.kilometros) {
                                var cabeceraKilometros = {
                                    label: 'Kilometros:',
                                    valor: notaPedido.kilometros
                                };
                                $scope.cabeceras.push(cabeceraKilometros);
                            }
                            $scope.cabeceras.push(cabeceraBomba);
                        }

                        $scope.remito = angular.copy(notaPedido);
                        $scope.remito.id = 0;
                        $scope.remito.remitoPlazo = notaPedido.notaPedidoPlazo;
                        $scope.remito.remitoPuntoDescarga = notaPedido.notaPedidoPuntoDescarga;

                        notaPedido.articulosNotaPedido.forEach(function (articulo) {
                            articulo.id = 0;
                            articulo.idRemito = 0;
                            articulo.precio =
                                (articulo.precio / notaPedido.cotizacion.VENDEDOR).toFixed(4);
                        });

                        $scope.remito.articulosRemito = notaPedido.articulosNotaPedido;

                        if (notaPedido.idPrecioCondicion > 0) {
                            $scope.idLista = notaPedido.precioCondicion.idListaPrecio;
                        } else {
                            $scope.idLista = -1;
                        }

                        enableObservaciones(notaPedido.observaciones ? true : false);
                        addArrayCabecera($scope.cabeceras);

                    }, function () {
                        // funcion ejecutada cuando se cancela el modal
                    }
                );
            };

            $scope.seleccionarRemito = function () {
                if ($scope.remitoIsDirty) {
                    focaModalService.confirm('¿Desea continuar? Se perderan los cambios')
                        .then(function () {
                            $scope.getRemitoModal();
                        });
                } else {
                    $scope.getRemitoModal();
                }
            };
            $scope.getRemitoModal = function () {
                var modalInstance = $uibModal.open(
                    {
                        ariaLabelledBy: 'Busqueda de Remito',
                        templateUrl: 'foca-modal-remito.html',
                        controller: 'focaModalRemitoController',
                        size: 'lg',
                        resolve: { usadoPor: function () { return 'remito'; } }
                    }
                );
                modalInstance.result.then(function (remito) {

                    remito.articulosRemito.forEach(function (articulo) {
                        articulo.precio =
                            (articulo.precio / remito.cotizacion.VENDEDOR).toFixed(4);
                    });

                    setearRemito(remito);

                }, function () {
                    // funcion ejecutada cuando se cancela el modal
                }
                );
            };
            //validacion por domicilio y por plazo pago
            $scope.crearRemito = function () {

                if (!remitoBusinessService.validarRemito($scope.remito, $scope.articulosFiltro())) {
                    return;
                }

                focaBotoneraLateralService.startGuardar();
                $scope.saveLoading = true;
                if ($localStorage.rutas) {
                    var rutaJson = JSON.parse($localStorage.rutas);
                    removeItemFromArr(rutaJson, 'venta-remito/crear');
                    $localStorage.rutas = JSON.stringify(rutaJson);
                }

                var save = {
                    remito: {
                        id: $scope.remito.id,
                        fechaRemito: $scope.now.toISOString().slice(0, 19).replace('T', ' '),
                        idCliente: $scope.remito.cliente.COD,
                        nombreCliente: $scope.remito.cliente.NOM,
                        cuitCliente: $scope.remito.cliente.CUIT,
                        total: $scope.getTotal() * $scope.remito.cotizacion.VENDEDOR,
                        numeroNotaPedido: $scope.remito.numeroNotaPedido,
                        idVendedor: parseInt($scope.remito.cliente.VEN),
                        idProveedor: $scope.remito.proveedor.COD,
                        idDomicilio: $scope.remito.idDomicilio || $scope.remito.domicilio.id,
                        idCotizacion: $scope.remito.cotizacion.ID,
                        idListaPrecio: $scope.idLista,
                        flete: $scope.remito.flete,
                        fob: $scope.remito.fob,
                        bomba: $scope.remito.bomba,
                        kilometros: $scope.remito.kilometros,
                        domicilioStamp: $scope.remito.domicilioStamp,
                        observaciones: $scope.remito.observaciones,
                        numeroRemito: parseInt($scope.comprobante),
                        sucursal: parseInt($scope.puntoVenta),
                        responsabilidadIvaCliente: $scope.remito.cliente.IVA,
                        descuento: 0,//TODO,
                        importeNeto: getImporte('netoUnitario'),
                        importeExento: getImporte('exentoUnitario'),
                        importeIva: getImporte('ivaUnitario'),
                        importeIvaServicios: 0,//TODO
                        importeImpuestoInterno: getImporte('impuestoInternoUnitario'),
                        importeImpuestoInterno1: getImporte('impuestoInterno1Unitario'),
                        importeImpuestoInterno2: getImporte('impuestoInterno2Unitario'),
                        percepcion: 0,//TODO
                        percepcionIva: 0,//TODO
                        redondeo: 0,//TODO
                        anulado: false,
                        planilla: $filter('date')($scope.now, 'ddMMyyyy'),
                        lugar: parseInt($scope.puntoVenta),
                        cuentaMadre: 0,//TODO
                        cuentaContable: 0,//TODO
                        asiento: 0,//TODO
                        e_hd: '',//TODO
                        c_hd: '',
                        numeroLiquidoProducto: 0,//TODO
                        estado: $scope.remito.estado,
                        destinoVenta: 0,//TODO
                        operacionTipo: 0, //TODO
                    },
                    notaPedido: $scope.notaPedido,
                    articulos: remitoBusinessService.quitarCotizacion($scope.articulosFiltro(),
                        $scope.remito.cotizacion.VENDEDOR),
                    puntosDescarga: remitoBusinessService.addPuntosDescarga(
                        $scope.remito.remitoPuntoDescarga),
                    plazos: $scope.remito.remitoPlazo
                };
                crearRemitoService.crearRemito(save).then(
                    function (data) {

                        focaBotoneraLateralService.endGuardar(true);
                        $scope.saveLoading = false;

                        if (data.status === 500) {
                            focaModalService.alert(data.data);
                            return;
                        }

                        abrirModalMail(data.data.id,
                            $scope.remito.cliente,
                            $filter('comprobante')([
                                $scope.puntoVenta,
                                data.data.numero
                            ])
                        );

                        config();

                    }, function (error) {
                        focaModalService.alert(error.data || 'Hubo un error al crear el remito');
                        focaBotoneraLateralService.endGuardar();
                        $scope.saveLoading = false;
                        console.info(error);
                    }
                );
            };

            $scope.seleccionarProductos = function () {
                if (!varlidarRemitoFacturado()) return;
                if (!varlidarRemitoAbierto()) return;
                if ($scope.notaPedido.id !== 0) {
                    $scope.idLista = parseInt($scope.notaPedido.idListaPrecio);
                }
                if ($scope.idLista === undefined) {
                    focaModalService.alert(
                        'Primero seleccione una lista de precio y condicion');
                    return;
                }
                var modalInstance = $uibModal.open(
                    {
                        ariaLabelledBy: 'Busqueda de Productos',
                        templateUrl: 'modal-busqueda-productos.html',
                        controller: 'modalBusquedaProductosCtrl',
                        resolve: {
                            parametroProducto: {
                                idLista: $scope.idLista,
                                cotizacion: $scope.remito.cotizacion.VENDEDOR,
                                simbolo: $scope.remito.cotizacion.moneda.SIMBOLO
                            }
                        },
                        size: 'lg'
                    }
                );
                modalInstance.result.then(
                    function (producto) {
                        var newArt =
                        {
                            id: 0,
                            idRemito: 0,
                            codigo: producto.codigo,
                            sector: producto.sector,
                            sectorCodigo: producto.sector + '-' + producto.codigo,
                            descripcion: producto.descripcionLarga,
                            item: $scope.remito.articulosRemito.length + 1,
                            nombre: producto.descripcion,
                            precio: parseFloat(producto.precio.toFixed(4)),
                            costoUnitario: producto.costo,
                            editCantidad: false,
                            editPrecio: false,
                            rubro: producto.CodRub,
                            ivaUnitario: producto.IMPIVA,
                            impuestoInternoUnitario: producto.ImpInt,
                            impuestoInterno1Unitario: producto.ImpInt2,
                            impuestoInterno2Unitario: producto.ImpInt3,
                            precioLista: producto.precio,
                            combustible: 1,
                            facturado: 0,
                            idArticulo: producto.id,
                            tasaIva: producto.tasaIVA
                        };

                        newArt.exentoUnitario = newArt.ivaUnitario ? 0 : producto.neto;
                        newArt.netoUnitario = newArt.ivaUnitario ? producto.neto : 0;

                        $scope.articuloACargar = newArt;
                        $scope.cargando = false;
                    }, function () {
                        // funcion ejecutada cuando se cancela el modal
                    }
                );
            };

            $scope.seleccionarPuntosDeDescarga = function () {
                if (!$scope.remito.cliente.COD || !$scope.remito.domicilio.id) {
                    focaModalService.alert('Primero seleccione un cliente y un domicilio');
                    return;
                } else {
                    var modalInstance = $uibModal.open(
                        {
                            ariaLabelledBy: 'Búsqueda de Puntos de descarga',
                            templateUrl: 'modal-punto-descarga.html',
                            controller: 'focaModalPuntoDescargaController',
                            size: 'lg',
                            resolve: {
                                filters: {
                                    idDomicilio: $scope.remito.domicilio.id,
                                    idCliente: $scope.remito.cliente.COD,
                                    articulos: $scope.remito.articulosRemito,
                                    puntosDescarga: $scope.remito.remitoPuntoDescarga,
                                    domicilio: $scope.remito.domicilio
                                }
                            }
                        }
                    );
                    modalInstance.result.then(
                        function (puntosDescarga) {

                            puntosDescarga.forEach(function (punto) {
                                $scope.remito.remitoPuntoDescarga.push(
                                    {
                                        puntoDescarga: punto
                                    }
                                );
                            });

                            $scope.$broadcast('addCabecera', {
                                label: 'Puntos de descarga:',
                                valor: getCabeceraPuntoDescarga(puntosDescarga)
                            });
                        }, function () {
                            $scope.abrirModalDomicilios($scope.cliente);
                        }
                    );
                }
            };

            $scope.seleccionarCliente = function () {
                if (!varlidarRemitoFacturado()) return;
                if (!varlidarRemitoAbierto()) return;
                var modalInstance = $uibModal.open(
                    {
                        ariaLabelledBy: 'Busqueda de Cliente',
                        templateUrl: 'foca-busqueda-cliente-modal.html',
                        controller: 'focaBusquedaClienteModalController',
                        resolve: {
                            parametros: function () {
                                return {
                                    // vendedor: $scope.idVendedor,
                                    cobrador: null,
                                    searchText: $scope.cliente ? $scope.cliente.nom : ''
                                };
                            },
                        },
                        backdrop: false,
                        size: 'lg'
                    }
                );
                modalInstance.result.then(
                    function (cliente) {

                        if ($scope.remito.precioCondicion !== undefined) {
                            focaModalService
                                .alert('Debe agregar lista de precio de cliente actual')
                                .then(function () {
                                    $scope.remito.precioCondicion = undefined;
                                    $scope.$broadcast('removeCabecera', 'Precios y Condiciones:');
                                    $filter('filter')($scope.botonera,
                                        { label: 'Precios y Condiciones' })[0].checked = false;
                                })
                                .catch(function () {
                                })
                        }

                        // if (angular.equals({}, cliente.vendedor)) {

                        //     focaModalService
                        //         .alert('El cliente seleccionado no tiene tiene ' +
                        //             'vendedor asignado.')
                        //         .then($scope.seleccionarCliente);

                        //     return;
                        // }

                        $scope.cliente = cliente;
                        $scope.abrirModalDomicilios(cliente);
                    }, function () {
                    }
                );
            };

            $scope.seleccionarEliminarRemito = function () {
                focaModalService.confirm('¿Desea eliminar este remito?').then(function (data) {
                    if (data) {
                        $scope.remito.anulado = true;
                        delete $scope.remito.remitoPlazo;
                        // delete $scope.remito.vendedor;
                        delete $scope.remito.proveedor;
                        delete $scope.remito.cliente;
                        delete $scope.remito.cotizacion;
                        delete $scope.remito.remitoPuntoDescarga;
                        delete $scope.remito.articulosRemito;
                        delete $scope.remito.fechaRemito;
                        crearRemitoService.eliminarRemito($scope.remito);
                    }
                    config();
                });
            };

            $scope.seleccionarProveedor = function () {
                if (!varlidarRemitoFacturado()) return;
                if (!varlidarRemitoAbierto()) return;
                var parametrosModal = {
                    titulo: 'Búsqueda de Proveedor',
                    query: '/proveedor',
                    columnas: [
                        {
                            nombre: 'Código',
                            propiedad: 'COD',
                            filtro: {
                                nombre: 'rellenarDigitos',
                                parametro: 5
                            }
                        },
                        {
                            nombre: 'Nombre',
                            propiedad: 'NOM'
                        },
                        {
                            nombre: 'CUIT',
                            propiedad: 'CUIT'
                        }
                    ],
                    tipo: 'POST',
                    json: { razonCuitCod: '' }
                };
                focaModalService.modal(parametrosModal).then(
                    function (proveedor) {
                        $scope.seleccionarFlete(proveedor);
                    }, function () { }
                );
            };

            $scope.seleccionarDomicilioDeEntrega = function () {
                if (!varlidarRemitoFacturado()) return;
                if (!varlidarRemitoAbierto()) return;
                if (!$scope.remito.cliente.COD && !$scope.cliente) {
                    focaModalService.alert('Seleccione un Cliente');
                    return;
                } else {
                    $scope.abrirModalDomicilios($scope.remito.cliente.COD ?
                        $scope.remito.cliente.COD : $scope.cliente);
                }
            };

            $scope.abrirModalDomicilios = function (cliente) {
                var modalInstanceDomicilio = $uibModal.open(
                    {
                        ariaLabelledBy: 'Busqueda de Domicilios',
                        templateUrl: 'modal-domicilio.html',
                        controller: 'focaModalDomicilioController',
                        backdrop: false,
                        size: 'lg',
                        resolve: {
                            idCliente: function () {
                                return $scope.remito.cliente.COD ? $scope.remito.cliente.COD :
                                    cliente.COD;
                            },
                            esNuevo: function () {
                                return ($scope.remito.cliente.COD ? false : cliente.esNuevo);
                            }
                        }
                    }
                );
                modalInstanceDomicilio.result
                    .then(function (domicilio) {
                        $scope.remito.domicilio = domicilio;
                        $scope.remito.cliente = cliente;
                        // $scope.remito.vendedor = cliente.vendedor;

                        var domicilioStamp =
                            domicilio.Calle + ' ' + domicilio.Numero + ', ' +
                            domicilio.Localidad + ', ' + domicilio.Provincia;

                        $scope.remito.domicilioStamp = domicilioStamp;

                        // $scope.$broadcast('addCabecera', {
                        //     label: 'Vendedor:',
                        //     valor: $filter('rellenarDigitos')($scope.remito.vendedor
                        //         .NUM, 3) + ' - ' + $scope.remito.vendedor.NOM
                        // });
                        $scope.$broadcast('addCabecera', {
                            label: 'Cliente:',
                            valor: $filter('rellenarDigitos')
                                ($scope.remito.cliente.COD, 3) +
                                ' - ' + $scope.remito.cliente.NOM
                        });
                        $scope.$broadcast('addCabecera', {
                            label: 'Domicilio:',
                            valor: domicilioStamp
                        });

                        if (domicilio.verPuntos) {
                            delete $scope.remito.domicilio.verPuntos;
                            $scope.seleccionarPuntosDeDescarga();
                        }

                        $filter('filter')($scope.botonera,
                            { label: 'Cliente' })[0].checked = true;
                        $filter('filter')($scope.botonera,
                            { label: 'Domicilio de Entrega' })[0].checked = true;

                    })
                    .catch(function (e) {
                        console.info(e);
                        $scope.seleccionarCliente(true);
                        return;
                    });
            };

            $scope.getTotal = function () {
                var total = 0;
                var arrayTempArticulos = $scope.articulosFiltro();
                for (var i = 0; i < arrayTempArticulos.length; i++) {
                    total += arrayTempArticulos[i].precio * arrayTempArticulos[i].cantidad;
                }
                return parseFloat(total.toFixed(2));
            };

            $scope.getSubTotal = function () {
                if ($scope.articuloACargar) {
                    return $scope.articuloACargar.precio * $scope.articuloACargar.cantidad;
                }
            };

            $scope.seleccionarPreciosYCondiciones = function () {
                if (!$scope.remito.cliente.COD) {
                    focaModalService.alert('Primero seleccione un cliente');
                    return;
                }
                if ($scope.remito.articulosRemito.length !== 0) {
                    if (varlidarRemitoFacturado() && varlidarRemitoAbierto()) {
                        abrirModal();
                    }
                } else {
                    abrirModal();
                }

                function abrirModal() {
                    var parametros = {
                        idCliente: $scope.remito.cliente.COD,
                        idListaPrecio: $scope.remito.cliente.MOD
                    };
                    var modalInstance = $uibModal.open(
                        {
                            ariaLabelledBy: 'Busqueda de Precio Condición',
                            templateUrl: 'modal-precio-condicion.html',
                            controller: 'focaModalPrecioCondicionController',
                            size: 'lg',
                            resolve: {
                                parametros: function () { return parametros; }
                            }
                        }
                    );
                    modalInstance.result.then(
                        function (precioCondicion) {
                            var cabecera = '';
                            var plazosConcat = '';
                            if (!Array.isArray(precioCondicion)) {
                                $scope.remito.idPrecioCondicion = precioCondicion.listaPrecio.ID;
                                $scope.remito.remitoPlazo = precioCondicion.plazoPago;
                                $scope.idLista = parseInt(precioCondicion.listaPrecio.ID) ?
                                    parseInt(precioCondicion.listaPrecio.ID) : -1;
                                $scope.remito.cliente.MOD = precioCondicion.listaPrecio.ID;
                                for (var i = 0; i < precioCondicion.plazoPago.length; i++) {
                                    plazosConcat += precioCondicion.plazoPago[i].dias + ', ';
                                }
                                plazosConcat = plazosConcat.substring(0, plazosConcat.length - 2);
                                cabecera = $filter('rellenarDigitos')
                                    (parseInt(precioCondicion.listaPrecio.ID), 4) +
                                    ' - ' + precioCondicion.listaPrecio.DES + ' ' +
                                    plazosConcat.trim();
                            } else { //Cuando se ingresan los plazos manualmente
                                $scope.remito.idPrecioCondicion = 0;
                                //-1, el modal productos busca todos los productos
                                $scope.idLista = -1;
                                $scope.remito.remitoPlazo = precioCondicion;
                                for (var j = 0; j < precioCondicion.length; j++) {
                                    plazosConcat += precioCondicion[j].dias + ' ';
                                }
                                cabecera = plazosConcat.trim();
                            }
                            var cabecerasFilter = !$filter('filter')($scope.cabeceras,
                                { label: 'Precios y Condiciones' });
                            if (!cabecerasFilter) {
                                $scope.cabeceras.push({
                                    label: 'Precios y Condiciones:',
                                    valor: parseInt(precioCondicion.listaPrecio.ID) + ' - ' +
                                        precioCondicion.listaPrecio.DES + ' ' +
                                        remitoBusinessService
                                            .plazoToString(precioCondicion.plazoPago)
                                });

                                $scope.remito.idListaPrecio = parseInt(
                                    precioCondicion.listaPrecio.ID);
                            }
                            $filter('filter')($scope.cabeceras,
                                { label: 'Precios y Condiciones' })[0].valor = cabecera;

                            $scope.remito.precioCondicion = precioCondicion;
                            $filter('filter')($scope.botonera,
                                { label: 'Precios y Condiciones' })[0].checked = true;
                            addArrayCabecera($scope.cabeceras);
                        }, function () {

                        }
                    );
                }
            };

            $scope.seleccionarFlete = function (proveedor) {
                if (!varlidarRemitoFacturado()) return;
                if (!varlidarRemitoAbierto()) return;
                var modalInstance = $uibModal.open(
                    {
                        ariaLabelledBy: 'Busqueda de Flete',
                        templateUrl: 'modal-flete.html',
                        controller: 'focaModalFleteController',
                        size: 'lg',
                        resolve: {
                            parametrosFlete:
                                function () {
                                    return {
                                        flete: $scope.remito.flete ? '1' :
                                            ($scope.remito.fob ? 'FOB' :
                                                ($scope.remito.flete === undefined ?
                                                    null : '0')),
                                        bomba: $scope.remito.bomba ? '1' :
                                            ($scope.remito.bomba === undefined ?
                                                null : '0'),
                                        kilometros: $scope.remito.kilometros
                                    };
                                }
                        }
                    }
                );
                modalInstance.result.then(
                    function (datos) {
                        $scope.remitoIsDirty = true;
                        $scope.remito.proveedor = proveedor;
                        $scope.remito.idProveedor = proveedor.COD;
                        $scope.$broadcast('addCabecera', {
                            label: 'Proveedor:',
                            valor: $filter('rellenarDigitos')(proveedor.COD, 5) + ' - ' +
                                proveedor.NOM
                        });

                        $scope.remito.flete = datos.flete;
                        $scope.remito.fob = datos.FOB;
                        $scope.remito.bomba = datos.bomba;
                        $scope.remito.kilometros = datos.kilometros;

                        $scope.$broadcast('addCabecera', {
                            label: 'Flete:',
                            valor: datos.flete ? 'Si' : ($scope.remito.fob ? 'FOB' : 'No')
                        });
                        if (datos.flete) {
                            $scope.$broadcast('addCabecera', {
                                label: 'Bomba:',
                                valor: datos.bomba ? 'Si' : 'No'
                            });
                            $scope.$broadcast('addCabecera', {
                                label: 'Kilometros:',
                                valor: datos.kilometros
                            });
                        } else {
                            $scope.$broadcast('removeCabecera', 'Bomba:');
                            $scope.$broadcast('removeCabecera', 'Kilometros:');
                            $scope.remito.bomba = false;
                            $scope.remito.kilometros = null;
                        }

                        $filter('filter')($scope.botonera,
                            { label: 'Proveedor' })[0].checked = true;
                    }, function () {
                        $scope.seleccionarTransportista();
                    }
                );
            };

            $scope.seleccionarMoneda = function () {
                if (!varlidarRemitoFacturado()) return;
                if (!varlidarRemitoAbierto()) return;
                var parametrosModal = {
                    titulo: 'Búsqueda de monedas',
                    query: '/moneda',
                    columnas: [
                        {
                            propiedad: 'DETALLE',
                            nombre: 'Nombre'
                        },
                        {
                            propiedad: 'SIMBOLO',
                            nombre: 'Símbolo'
                        }
                    ],
                    size: 'md'
                };
                focaModalService.modal(parametrosModal).then(
                    function (moneda) {

                        if (moneda.ID !== 1) {
                            $scope.abrirModalCotizacion(moneda);
                            return;
                        }

                        crearRemitoService.getCotizacionByIdMoneda(1)
                            .then(function (res) {

                                cotizacionPArgentino = res.data[0].cotizaciones[0];
                                cotizacionPArgentino.moneda = moneda;

                                actualizarCabeceraMoneda(cotizacionPArgentino);
                                $filter('filter')($scope.botonera,
                                    { label: 'Moneda' })[0].checked = true;
                                $scope.remito.cotizacion = cotizacionPArgentino;
                            });
                    }, function () {

                    }
                );
            };

            $scope.seleccionarObservaciones = function () {
                focaModalService
                    .prompt({
                        titulo: 'Observaciones',
                        value: $scope.remito.observaciones,
                        textarea: true,
                        readonly: false
                    })
                    .then(function (observaciones) {
                        $scope.remito.observaciones = observaciones;
                    });
            };

            $scope.abrirModalCotizacion = function (moneda) {
                var modalInstance = $uibModal.open(
                    {
                        ariaLabelledBy: 'Busqueda de Cotización',
                        templateUrl: 'modal-cotizacion.html',
                        controller: 'focaModalCotizacionController',
                        size: 'lg',
                        resolve: { idMoneda: function () { return moneda.ID; } }
                    }
                );
                modalInstance.result.then(
                    function (cotizacion) {
                        cotizacion.moneda = moneda;
                        $scope.remitoIsDirty = true;
                        actualizarCabeceraMoneda(cotizacion);
                        $filter('filter')($scope.botonera,
                            { label: 'Moneda' })[0].checked = true;
                        $scope.remito.cotizacion = cotizacion;
                    }, function () {

                    }
                );
            };

            function actualizarCabeceraMoneda(cotizacion) {

                $scope.remito.articulosRemito.forEach(function (art) {
                    art.precio = (art.precio * $scope.remito.cotizacion.VENDEDOR).toFixed(4);
                    art.precio = (art.precio / cotizacion.VENDEDOR).toFixed(4);
                });

                if (cotizacion.moneda.DETALLE === 'PESOS ARGENTINOS') {
                    $scope.$broadcast('removeCabecera', 'Moneda:');
                    $scope.$broadcast('removeCabecera', 'Fecha cotizacion:');
                    $scope.$broadcast('removeCabecera', 'Cotizacion:');
                } else {
                    $scope.$broadcast('addCabecera', {
                        label: 'Moneda:',
                        valor: cotizacion.moneda.DETALLE
                    });
                    $scope.$broadcast('addCabecera', {
                        label: 'Fecha cotizacion:',
                        valor: $filter('date')(cotizacion.FECHA, 'dd/MM/yyyy')
                    });
                    $scope.$broadcast('addCabecera', {
                        label: 'Cotizacion:',
                        valor: $filter('number')(cotizacion.VENDEDOR, '2')
                    });
                }
            }

            $scope.agregarATabla = function (key) {
                if (key === 13) {
                    if (!$scope.articuloACargar.cantidad || !$scope.articuloACargar.precio) {
                        focaModalService.alert('El valor debe ser al menos 1');
                        return;
                    }
                    delete $scope.articuloACargar.sectorCodigo;
                    $scope.remito.articulosRemito.push($scope.articuloACargar);
                    $scope.cargando = true;
                }
            };

            $scope.quitarArticulo = function (articulo) {
                articulo.idRemito = -1;
            };

            $scope.articulosFiltro = function () {

                var result = $scope.remito.articulosRemito.filter(function (articulo) {
                    return articulo.idRemito >= 0;
                });

                // Agrego checked en cabecera si hay datos
                if (result.length) {
                    $filter('filter')($scope.botonera, { label: 'Productos' })[0].checked = true;
                } else {
                    $filter('filter')($scope.botonera, { label: 'Productos' })[0].checked = false;
                }
                return result;
            };

            $scope.editarArticulo = function (key, articulo, tmpCantidad, tmpPrecio) {
                if (key === 13) {
                    if (!articulo.cantidad || !articulo.precio || !tmpCantidad || !tmpPrecio) {
                        focaModalService.alert('Los valores deben ser al menos 1');
                        return;
                    } else if (tmpCantidad === '0' || tmpPrecio === '0') {
                        focaModalService.alert('Esta ingresando un producto con valor 0');
                    } else if (articulo.cantidad < 0 || articulo.precio < 0) {
                        focaModalService.alert('Los valores no pueden ser negativos');
                        return;
                    }
                    articulo.cantidad = tmpCantidad;
                    articulo.precio = tmpPrecio;
                    $scope.getTotal();
                    articulo.editCantidad = articulo.editPrecio = false;
                }
            };

            $scope.cancelarEditar = function (articulo) {
                $scope.tmpCantidad = articulo.cantidad;
                $scope.tmpPrecio = articulo.precio;
                articulo.editCantidad = articulo.editPrecio = false;
            };

            $scope.cambioEdit = function (articulo, propiedad) {
                if (propiedad === 'cantidad') {
                    articulo.editCantidad = true;
                } else if (propiedad === 'precio') {
                    articulo.editPrecio = true;
                }
            };

            $scope.resetFilter = function () {
                $scope.articuloACargar = {};
                $scope.cargando = true;
            };
            //Recibe aviso si el teclado está en uso
            $rootScope.$on('usarTeclado', function (event, data) {
                if (data) {
                    $scope.mostrarTeclado = true;
                    return;
                }
                $scope.mostrarTeclado = false;
            });

            $scope.selectFocus = function ($event) {
                // Si el teclado esta en uso no selecciona el valor
                if ($scope.mostrarTeclado) {
                    return;
                }
                $event.target.select();
            };

            function addArrayCabecera(array) {
                for (var i = 0; i < array.length; i++) {
                    $scope.$broadcast('addCabecera', {
                        label: array[i].label,
                        valor: array[i].valor
                    });
                }
            }

            function rellenar(relleno, longitud) {
                relleno = '' + relleno;
                while (relleno.length < longitud) {
                    relleno = '0' + relleno;
                }
                return relleno;
            }

            function varlidarRemitoFacturado() {
                if ($scope.remito.estado !== 5) {
                    return true;
                } else {
                    focaModalService.alert('No se puede editar un remito facturado');
                    return false;
                }
            }

            function varlidarRemitoAbierto() {
                if (!$scope.remito.hojaRuta) return true;
                if ($scope.remito.hojaRuta.abierta !== '1') {
                    return true;
                } else {
                    focaModalService.alert('No se puede editar un remito abierto');
                    return false;
                }
            }

            function removeItemFromArr(arr, item) {
                var i = arr.indexOf(item);

                if (i !== -1) {
                    arr.splice(i, 1);
                }
            }

            function salir() {
                var confirmacion = false;

                if (!angular.equals($scope.remito, $scope.inicial)) {
                    confirmacion = true;
                }

                if (confirmacion) {
                    focaModalService.confirm(
                        '¿Está seguro de que desea salir? Se perderán todos los datos cargados.'
                    ).then(function (data) {
                        if (data) {
                            $location.path('/');
                            var rutaJson = JSON.parse($localStorage.rutas);
                            removeItemFromArr(rutaJson, 'venta-remito/crear');
                            $localStorage.rutas = JSON.stringify(rutaJson);
                        }
                    });
                } else {
                    $location.path('/');
                }
            }

            function enableObservaciones(val) {
                var boton = $scope.botonera.filter(function (botonObs) {
                    return botonObs.label === 'Observaciones';
                });
                boton[0].disable = !val;
            }

            function setearRemito(remito) {
                //añado cabeceras
                var esAbierto = remito.hojaRuta ?
                    (remito.hojaRuta.abierta === '1') : false;
                if (remito.estado !== 5 && remito.id && !esAbierto) {

                    $scope.botonera.forEach(function (boton) {

                        if (boton.label === 'Eliminar Remito') {
                            boton.disable = false;
                        }
                    });
                }
                $scope.$broadcast('removeCabecera', 'Moneda:');
                $scope.$broadcast('removeCabecera', 'Fecha cotizacion:');
                $scope.$broadcast('removeCabecera', 'Cotizacion:');
                // $scope.$broadcast('removeCabecera', 'Vendedor:');

                $scope.cabeceras = [];

                if (remito.cotizacion && remito.cotizacion.moneda.CODIGO_AFIP !== 'PES') {
                    $scope.cabeceras.push({
                        label: 'Moneda:',
                        valor: remito.cotizacion.moneda.DETALLE
                    });
                    $scope.cabeceras.push({
                        label: 'Fecha cotizacion:',
                        valor: $filter('date')(remito.cotizacion.FECHA,
                            'dd/MM/yyyy')
                    });
                    $scope.cabeceras.push({
                        label: 'Cotizacion:',
                        valor: $filter('number')(remito.cotizacion.VENDEDOR,
                            '2')
                    });
                }

                if (remito.cotizacion && remito.cotizacion.moneda) {
                    $filter('filter')($scope.botonera, { label: 'Moneda' })[0].checked = true;
                }

                if (remito.cliente && remito.cliente.COD) {
                    $scope.cabeceras.push({
                        label: 'Cliente:',
                        valor: $filter('rellenarDigitos')(remito.cliente.COD, 3) + ' - ' +
                            remito.cliente.NOM
                    });
                    $scope.cabeceras.push({
                        label: 'Domicilio:',
                        valor: remito.domicilioStamp
                    });

                    $filter('filter')($scope.botonera,
                        { label: 'Domicilio de Entrega' })[0].checked = true;
                    $filter('filter')($scope.botonera, { label: 'Cliente' })[0].checked = true;
                }
                // if (remito.vendedor && remito.vendedor.NUM) {
                //     $scope.cabeceras.push({
                //         label: 'Vendedor:',
                //         valor: $filter('rellenarDigitos')(remito.vendedor.NUM, 3) +
                //             ' - ' + remito.vendedor.NOM
                //     });
                // }
                if (remito.proveedor && remito.proveedor.COD) {
                    $scope.cabeceras.push({
                        label: 'Proveedor:',
                        valor: $filter('rellenarDigitos')(remito.proveedor.COD, 5) +
                            ' - ' + remito.proveedor.NOM
                    });

                    $filter('filter')($scope.botonera, { label: 'Proveedor' })[0].checked = true;
                }
                if (remito.flete !== undefined && remito.fob !== undefined) {
                    $scope.cabeceras.push({
                        label: 'Flete:',
                        valor: remito.fob ? 'FOB' : (
                            remito.flete ? 'Si' : 'No')
                    });
                }
                if (remito.remitoPlazo) {
                    valorPrecioCondicion();
                    $filter('filter')($scope.botonera,
                        { label: 'Precios y condiciones' })[0].checked = true;
                }

                function valorPrecioCondicion() {
                    if (parseInt(remito.idListaPrecio)) {
                        crearRemitoService.getListaPrecioById(parseInt(remito.idListaPrecio))
                            .then(function (res) {
                                $timeout(function () {
                                    $scope.cabeceras.push({
                                        label: 'Precios y Condiciones:',
                                        valor: parseInt(res.data[0].ID) + ' - ' +
                                            res.data[0].DES + ' ' +
                                            remitoBusinessService
                                                .plazoToString(remito.remitoPlazo)
                                    });
                                    addArrayCabecera($scope.cabeceras);
                                }, true);

                            });
                        $scope.idLista = parseInt(remito.idListaPrecio);
                    }
                }

                if (remito.flete === 1) {
                    var cabeceraBomba = {
                        label: 'Bomba',
                        valor: remito.bomba === 1 ? 'Si' : 'No'
                    };
                    if (remito.kilometros) {
                        var cabeceraKilometros = {
                            label: 'Kilometros',
                            valor: remito.kilometros
                        };
                        $scope.cabeceras.push(cabeceraKilometros);
                    }
                    $scope.cabeceras.push(cabeceraBomba);
                }

                if (remito.idPrecioCondicion > 0) {
                    $scope.idLista = remito.precioCondicion.idListaPrecio;
                } else if (remito.idPrecioCondicion) {
                    $scope.idLista = -1;
                }
                $scope.puntoVenta = rellenar(remito.sucursal, 4);
                $scope.comprobante = rellenar(remito.numeroRemito, 8);
                $scope.remito = remito;
                if ($scope.remito.remitoPuntoDescarga.length) {
                    var puntoDescarga = [];

                    $scope.remito.remitoPuntoDescarga.forEach(function (remitoPuntoDescarga) {
                        puntoDescarga.push(remitoPuntoDescarga.puntoDescarga);
                    });

                    $scope.cabeceras.push({
                        label: 'Puntos de descarga: ',
                        valor: $filter('rellenarDigitos')(getCabeceraPuntoDescarga(puntoDescarga))
                    });
                }
                $scope.remitoIsDirty = false;


                addArrayCabecera($scope.cabeceras);
            }

            function getLSRemito() {
                var remito = JSON.parse($localStorage.remito || null);
                if (remito) {
                    setearRemito(remito);
                    delete $localStorage.remito;
                }
            }

            function getCabeceraPuntoDescarga(puntosDescarga) {
                var puntosStamp = '';
                puntosDescarga.forEach(function (punto, idx, arr) {
                    puntosStamp += punto.descripcion;
                    if ((idx + 1) !== arr.length) puntosStamp += ', ';
                });
                return puntosStamp;
            }

            function abrirModalMail(id, cliente, numeroRemito) {
                focaModalService.mail(
                    {
                        titulo: 'Comprobante de remito Nº ' + numeroRemito,
                        descarga: {
                            nombre: numeroRemito + '.pdf',
                            url: '/remito/comprobante',
                        },
                        descargaSinValorizar: {
                            nombre: numeroRemito + '.pdf',
                            url: '/remito/comprobante-sin-valorizar',
                        },
                        envio: {
                            mailCliente: cliente.MAIL,
                            url: '/remito/mail',
                        },
                        envioSinValorizar: {
                            mailCliente: cliente.MAIL,
                            url: '/remito/mail-sin-valorizar'
                        },
                        options: {
                            idRemito: id
                        }
                    }
                )
                    .then(function (res) {
                        if (res === false) {
                            abrirModalMail(id);
                            focaModalService.alert('Descarga o envíe su remito ' +
                                'antes de cerrar esta ventana');
                        }
                    });
            }
            //recibo la propiedad por la cual quiero obtener el valor
            function getImporte(propiedad) {
                var importe = 0;

                $scope.articulosFiltro().forEach(function (articulo) {

                    if (articulo[propiedad]) {
                        importe += articulo[propiedad] * articulo.cantidad;
                    }
                    return;

                });

                return importe;
            }
        }
    ]);
