angular.module('focaCrearRemito')
    .service('crearRemitoService', ['$http', 'API_ENDPOINT',
    function($http, API_ENDPOINT) {
        var route = API_ENDPOINT.URL;
        return {
            // getVendedorById: function (idVendedor) {
            //     return $http.get(route + '/vendedor-cobrador/' + idVendedor);
            // },
            crearRemito: function(remito) {
                // TODO: Cambiar para usar el servicio /remito
                return $http.post(route + '/remito/guardar', remito);
            },
            getRemitoById: function(id) {
                return $http.get(route + '/remito/obtener/' + id);
            },
            obtenerRemito: function() {
                return $http.get(route +'/nota-pedido');
            },
            setRemito: function(remito) {
                this.remito = remito;
            },
            clearRemito: function() {
                this.remito = undefined;
            },
            getRemito: function() {
                return this.remito;
            },
            getArticulosByIdRemito: function(id) {
                return $http.get(route+'/articulos/nota-pedido/'+id);
            },
            crearArticulosParaRemito: function(articuloRemito) {
                return $http.post(route + '/articulos/remito',
                    {articuloRemito: articuloRemito});
            },
            getProveedorById: function(id) {
                return $http.get(API_ENDPOINT.URL + '/proveedor/' + id);
            },
            getDomiciliosByIdRemito: function(id) {
                return $http.get(route +'/nota-pedido/'+id+'/domicilios');
            },
            getDomiciliosByIdCliente: function(id) {
                var idTipoEntrega = 2;//Solo traigo los domicilios que tienen tipo 2 (tipo entrega)
                return $http.get(route + '/domicilio/tipo/' + idTipoEntrega + '/cliente/' + id );
            },
            getPrecioCondicion: function() {
                return $http.get(route + '/precio-condicion');
            },
            getPrecioCondicionById: function(id) {
                return $http.get(route + '/precio-condicion/' + id);
            },
            getListaPrecioById: function (id) {
                return $http.get(route + '/lista-precio/' + id); 
            },
            getPlazoPagoByPrecioCondicion: function(id) {
                return $http.get(route + '/plazo-pago/precio-condicion/'+ id);
            },
            crearFlete: function(flete) {
                return $http.post(route + '/flete', {flete : flete});
            },
            crearPlazosParaRemito: function(plazos) {
                return $http.post(route + '/plazo-pago/remito', plazos);
            },
            getCotizacionByIdMoneda: function(id) {
                return $http.get(route + '/moneda/' + id);
            },
            crearEstadoParaRemito: function(estado) {
                return $http.post(route + '/estado', {estado: estado});
            },
            getNumeroRemito: function(tipoComprobante) {

                var tipo = tipoComprobante ? '/' + tipoComprobante : '';

                return $http.get(route + '/remito/numero-siguiente' + tipo);
            },
            imprimirRemitoByIdRemito: function(idRemito) {
                return $http.get(route + '/remito/comprobante/' + idRemito , {
                    responseType: 'arraybuffer'
                });
            },
            getPuntosDescargaByClienDom: function(idDomicilio, idCliente) {
                return $http.get(API_ENDPOINT.URL + '/punto-descarga/' +
                    idDomicilio + '/' + idCliente);
            },
            enviarCorreo: function(options) {
                return $http.post(API_ENDPOINT.URL + '/remito/mail', options);
            },
            getParametros: function() {
                return $http.get(API_ENDPOINT.URL + '/parametros/remito');
            },
            crearPuntosDescarga: function(puntosDescarga) {
                return $http.post(route + '/puntos-descarga/remito',
                    {puntosDescarga: puntosDescarga});
            },
            getBotonera: function() {
                return [
                    {
                        label: 'Nota pedido',
                        image: 'notaDePedido.png'
                    },
                    {
                        label: 'Cliente',
                        image:  'cliente.png'
                    },
                    {
                        label: 'Domicilio de Entrega',
                        image: 'domicilioDeEntrega.png'
                    },
                    {
                        label: 'Proveedor',
                        image:  'proveedor.png'
                    },
                    {
                        label: 'Moneda',
                        image:  'moneda.png'
                    },
                    {
                        label: 'Precios y condiciones',
                        image:  'precios-condiciones.png'
                    },
                    {
                        label: 'Productos',
                        image: 'productos.png'
                    },
                    {
                        label: 'Observaciones',
                        image: 'botonObservaciones.png',
                        disable: true
                    },
                    {
                        label: 'Eliminar Remito',
                        image: 'eliminarRemito.png',
                        disable: true
                    }
                ];
            },
            eliminarRemito: function (remito) {
                return $http.delete(API_ENDPOINT.URL + '/remito/anular/' + remito.id);
            }
        };
    }]);
