angular.module('focaModalDetalleHojaRuta')
    .controller('focaModalDetalleHojaRutaController',
        [
            '$filter', '$scope', '$uibModalInstance', 'parametros', 'focaModalDetalleHojaRutaService',
            'focaModalService', 'focaSeguimientoService', '$uibModal',
            function ($filter, $scope, $uibModalInstance, parametros, focaModalDetalleHojaRutaService,
                focaModalService, focaSeguimientoService, $uibModal) {
                //#region SETEO VARIABLES
                $scope.remito = parametros.remito;
                $scope.cisternas = parametros.remito.cisternas;
                $scope.articuloSeleccionado = {};
                $scope.aDescargar = [];
                $scope.cargando = false;
                //#endregion

                function init() {
                    if ($scope.remito.rechazado) {
                        $scope.readonly = true;
                    }
                    var articuloAChequear = $scope.remito.articulosRemito.filter(function (articulo) {
                        return !articulo.descargado;
                    });
                    if (!articuloAChequear.length || $scope.remito.rechazado) {
                        $scope.readonly = true;
                        $scope.cambio($scope.remito.articulosRemito[0]);
                    } else {
                        $scope.cambio(articuloAChequear[0]);
                    }
                }

                $scope.cambio = function (articulo) {
                    // if (!$scope.articuloSeleccionado.descargado) {
                    //     $scope.articuloSeleccionado.cantidadDescargada = 0;
                    // }
                    $scope.aDescargar = [];
                    $scope.articuloSeleccionado = articulo;
                };
                $scope.descargar = function (key) {
                    if (key === 13) {
                        $scope.cargando = true;
                        var hojaRutaMovimientos = [];
                        var cisternaMovimientos = [];
                        var cisternaCargas = [];
                        var totalADescargar = 0;
                        for (var i = 0; i < $scope.aDescargar.length; i++) {
                            totalADescargar += $scope.aDescargar[i] || 0;
                        }
                        focaModalService
                            .confirm('¿Desea descargar ' + totalADescargar + ' litros de ' +
                                $scope.articuloSeleccionado.descripcion + '?')
                            .then(descargar, function () {
                                $scope.cargando = false;
                            });
                    }
                    function descargar() {
                        for (var i = 0; i < $scope.cisternas.length; i++) {
                            var descarga = $scope.aDescargar[i];
                            var cisternaCarga = $scope.cisternas[i].cisternaCarga;
                            if (!descarga) continue;
                            if (descarga > cisternaCarga.cantidad) {
                                focaModalService.alert('La cantidad a descargar no debe ser ' +
                                    'mayor a la cantidad de la cisterna');
                                $scope.cargando = false;
                                return;
                            }

                            cisternaCarga.cantidad -= descarga;
                            $scope.articuloSeleccionado.cantidadDescargada += descarga;

                            //Guardar
                            var now = new Date();
                            var cisternaMovimiento = {
                                fecha: now.toISOString().slice(0, 19).replace('T', ' '),
                                cantidad: descarga,
                                metodo: 'descarga',
                                idCisternaCarga: cisternaCarga.id,
                                idRemito: $scope.remito.id
                            };
                            var hojaRutaMovimiento = {
                                reciboDescarga: $scope.numeroRecibo,
                                idRemito: $scope.remito.id
                            };
                            delete cisternaCarga.articulo;
                            cisternaCargas.push(cisternaCarga);
                            cisternaMovimientos.push(cisternaMovimiento);
                            hojaRutaMovimientos.push(hojaRutaMovimiento);
                        }
                        var save = {
                            cisternaCargas: cisternaCargas,
                            cisternaMovimientos: cisternaMovimientos,
                            hojaRutaMovimientos: hojaRutaMovimientos,
                            articulo: $scope.articuloSeleccionado
                        };

                        focaSeguimientoService.obtenerPosicion(getPosition);

                        $scope.aDescargar = [];
                        $scope.remito.observaciones = '';

                        if ($scope.articuloSeleccionado.cantidadDescargada ===
                            $scope.articuloSeleccionado.cantidad) {

                            $scope.articuloSeleccionado.descargado = true;
                        }

                        var siguienteArticulo = $scope.remito.articulosRemito.filter(
                            function (articulo) {
                                return articulo.id != $scope.articuloSeleccionado.id;
                            }
                        );

                        if (siguienteArticulo.length) {
                            $scope.cambio(siguienteArticulo[0]);
                        }

                        success().then(function () {
                            $uibModalInstance.close($scope.remito);
                        });
                        //TODO: enviar puntos de descarga, se quita para la demo.
                        // $scope.actualizarPuntoDescarga();

                        function getPosition(position) {

                            $scope.posicion = {
                                latitud: position.coords.latitude,
                                longitud: position.coords.longitude,
                                actividad: 'Entrega de producto',
                                observaciones: $scope.remito.observaciones
                            }

                            focaModalDetalleHojaRutaService
                                .postMovimientoHojaRuta(save)
                                .then(guardarSeguimiento);
                        }

                        function guardarSeguimiento(res) {

                            $scope.posicion.idComprobante = res.data[0].id;
                            focaModalDetalleHojaRutaService.guardarPosicion({ posicion: $scope.posicion });
                        }
                    }
                };
                $scope.cancel = function () {
                    $uibModalInstance.dismiss('cancel');
                };
                $scope.distribucionDisponible = function () {

                    return $scope.cisternas.filter(function (cisterna, index) {

                        return $scope.aDescargar[index] ? $scope.aDescargar[index] >
                            cisterna.cisternaCarga.cantidad : cisterna;

                    }).length;

                };
                // $scope.actualizarArticulo = function () {
                //     // $scope.articuloSeleccionado.cantidadDescargada = 0;
                //     for (var i = 0; i < $scope.aDescargar.length; i++) {

                //         var aRestar = parseInt($scope.aDescargar[i].toString()
                //             .slice(0, $scope.aDescargar[i].toString().length - 1));

                //         if (aRestar && aRestar != $scope.aDescargar[i]) {
                //             $scope.articuloSeleccionado.cantidadDescargada -= aRestar;
                //         }

                //         $scope.articuloSeleccionado.cantidadDescargada +=
                //             parseFloat($scope.aDescargar[i]) || 0;
                //     }
                // };
                $scope.actualizarPuntoDescarga = function () {
                    var modalInstance = $uibModal.open(
                        {
                            ariaLabelledBy: 'Actualizar punto de descarga',
                            templateUrl: 'modal-actualizar-punto-descarga.html',
                            controller: 'focaModalActualizarPuntoDescargaController',
                            resolve: {
                                notaPedido: function () {
                                    return $scope.remito.notaPedido;
                                }
                            },
                            size: 'lg'
                        }
                    );
                    modalInstance.result.then(function () {
                        success().then(function () {
                            $uibModalInstance.close($scope.remito);
                        });
                    }, function () {
                        success().then(function () {
                            $uibModalInstance.close($scope.remito);
                        });
                    });
                };
                $scope.rechazar = function () {
                    focaModalService
                        .prompt({
                            titulo: 'Aclare el motivo de rechazo'
                        })
                        .then(function (motivo) {
                            $scope.cargando = true;
                            var remitoRechazado = $.extend(true, {}, $scope.remito);
                            delete remitoRechazado.articulosRemito;
                            delete remitoRechazado.notaPedido;
                            delete remitoRechazado.cisternas;
                            delete remitoRechazado.cotizacion;
                            delete remitoRechazado.proveedor;
                            delete remitoRechazado.vendedor;
                            remitoRechazado.rechazado = true;
                            remitoRechazado.motivoRechazo = motivo;
                            remitoRechazado.fechaRemito =
                                remitoRechazado.fechaRemito.slice(0, 19).replace('T', ' ');

                            focaModalDetalleHojaRutaService.rechazarRemito(remitoRechazado)
                                .then(function (res) {
                                    focaSeguimientoService.guardarPosicion(
                                        'Entrega de producto',
                                        res.data[1].id,
                                        motivo);
                                    $scope.remito.rechazado = true;
                                    success().then(function () {
                                        $uibModalInstance.close($scope.remito);
                                    });
                                })
                                .catch(error);
                            $scope.readonly = true;
                        })
                        .catch(function (e) { console.info("modal", e); });
                };

                //#region FUNCIONES
                init();
                function error(error) {
                    focaModalService.alert('Hubo un error ' + error);
                }
                function success() {
                    $scope.cargando = false;
                    return focaModalService.alert('Operación realizada con éxito');
                }
                //#endregion
            }
        ])
    .controller('focaModalActualizarPuntoDescargaController',
        [
            '$scope',
            '$uibModalInstance',
            'focaSeguimientoService',
            'focaModalService',
            'notaPedido',
            'focaModalDetalleHojaRutaService',
            function ($scope, $uibModalInstance, focaSeguimientoService,
                focaModalService, notaPedido, focaModalDetalleHojaRutaService) {
                $scope.notaPedido = notaPedido;
                $scope.descripcion = '';
                focaSeguimientoService.obtenerPosicion(function (res) {
                    $scope.posicion = res.coords;
                });

                $scope.cancel = function () {
                    if ($scope.ingreso) {
                        $scope.ingreso = false;
                    } else {
                        $uibModalInstance.dismiss();
                    }
                };

                $scope.select = function (puntoDescarga) {
                    if (!$scope.posicion) {
                        focaModalService.alert('No se pudo obtener la ubicación');
                        return;
                    }
                    puntoDescarga.latitud = $scope.posicion.latitude;
                    puntoDescarga.longitud = $scope.posicion.longitude;
                    focaModalDetalleHojaRutaService.guardarPuntoDescarga(puntoDescarga);
                    $uibModalInstance.close();
                };

                $scope.guardar = function () {
                    if (!$scope.posicion) {
                        focaModalService.alert('No se pudo obtener la ubicación');
                        return;
                    }
                    focaModalDetalleHojaRutaService
                        .guardarPuntoDescarga({
                            id: 0,
                            id_cliente: $scope.notaPedido.idCliente,
                            id_da_config_0: $scope.notaPedido.idDomicilio,
                            descripcion: $scope.descripcion,
                            latitud: $scope.posicion.latitude,
                            longitud: $scope.posicion.longitude
                        })
                        .then(function (res) {
                            $uibModalInstance.close(res.data);
                        });
                };

            }
        ]
    );
