angular.module('focaModalDetalleHojaRuta')
    .service('focaModalDetalleHojaRutaService', [
        '$http',
        'API_ENDPOINT',
        function($http, API_ENDPOINT) {
            return {
                getDetallesHojaRuta: function() {
                    return $http.get(API_ENDPOINT.URL + '/transportista');
                },
                getCisternasByIdRemito: function(idRemito) {
                    return $http.get(API_ENDPOINT.URL + '/cisternas/obtener/remito/' + idRemito);
                },
                getRemitoById: function(idRemito) {
                    return $http.get(API_ENDPOINT.URL + '/remito/obtener/' + idRemito + '/punto');
                },
                postMovimientoHojaRuta: function(datos) {
                    return $http.post(API_ENDPOINT.URL + '/hoja-ruta/movimiento', datos);
                },
                rechazarRemito: function(remito) {
                    return $http.post(API_ENDPOINT.URL + '/remito/rechazar', {remito: remito});
                },
                guardarPuntoDescarga: function(puntoDescarga) {
                    return $http.post(API_ENDPOINT.URL + '/punto-descarga',
                        {puntoDescarga: puntoDescarga});
                },
                guardarPosicion: function(posicion) {
                    return $http.post(API_ENDPOINT.URL + '/seguimiento', posicion);
                }
            };
        }
    ]);
