const templateCache = require('gulp-angular-templatecache');
const concat        = require('gulp-concat');
const htmlmin       = require('gulp-htmlmin');
const rename        = require('gulp-rename');
const uglify        = require('gulp-uglify');
const gulp          = require('gulp');
const pump          = require('pump');
const jshint        = require('gulp-jshint');
const replace       = require('gulp-replace');
const connect       = require('gulp-connect');
const clean         = require('gulp-clean');

var paths = {
    srcJS:    'src/js/*.js',
    srcViews: 'src/views/*.html',
    tmp:      'tmp',
    dist:     'dist/'
};

gulp.task('clean', function(){
    return gulp.src(['tmp', 'dist'], {read: false})
    .pipe(clean());
});

gulp.task('templates', ['clean'], function() {
    return pump(
        [
            gulp.src(paths.srcViews),
            htmlmin(),
            templateCache('views.js', {
                module: 'focaModalPrecioCondicion',
                root: ''
            }),
            gulp.dest(paths.tmp)
        ]
    );
});

gulp.task('uglify', ['templates'], function() {
    return pump(
        [
            gulp.src([
                paths.srcJS,
                'tmp/views.js'
            ]),
            concat('foca-modal-precio-condiciones.js'),
            replace('src/views/', ''),
            replace("['ui.bootstrap', 'focaDirectivas', 'focaModal']", '[]'),
            gulp.dest(paths.tmp),
            rename('foca-modal-precio-condiciones.min.js'),
            uglify(),
            gulp.dest(paths.dist)
        ]
    );
});

gulp.task('pre-commit', function() {
    return pump(
        [
            gulp.src(paths.srcJS),
            jshint('.jshintrc'),
            jshint.reporter('default'),
            jshint.reporter('fail')
        ]
    );
});

gulp.task('webserver', function() {
    pump [
        connect.server({port: 3000})
    ]
});

gulp.task('clean-post-install', function(){
    return gulp.src(['src', 'tmp', '.jshintrc','readme.md', '.gitignore', 'gulpfile.js',
                     'index.html'], {read: false})
    .pipe(clean());
});

gulp.task('default', ['webserver']);

gulp.task('watch', function() {
    gulp.watch([paths.srcJS, paths.srcViews], ['uglify'])
});
