angular.module('focaModalPrecioCondicion')
    .controller('focaModalPrecioCondicionController',
        [
            '$timeout',
            '$filter',
            '$scope',
            '$uibModal',
            '$uibModalInstance',
            'focaModalService',
            'focaModalPrecioCondicionService',
            'parametros',
            function (
                $timeout, $filter, $scope, $uibModal, $uibModalInstance,
                focaModalService, focaModalPrecioCondicionService, parametros
            ) {
                $scope.plazos = [
                    {
                        dias: 0,
                        idCliente: parametros.idCliente,
                        activo: true
                    }
                ];
                $scope.remito = parametros.remito;
                $scope.notaPedido = parametros.notaPedido;
                $scope.openModalListaDePrecios = false;
                $scope.associatedList = true;
                $scope.listaDePreciosAlternativa = null;

                onInit();

                function onInit() {
                    //Metodo para traer la lista de precio asociada al cliente
                    focaModalPrecioCondicionService.getListaPrecio(parametros.idListaPrecio)
                    .then(function (res) {
                        $scope.listaDePreciosAsociada = res.data[0];
                    })
                    .catch(function (e) { console.error(e) });
                    focaModalPrecioCondicionService.getPlazosByIdCliente(parametros.idCliente)
                    .then(function (res) {
                        res.data.forEach(function (item) {
                            $scope.plazos.push(item);
                        });
                    })
                    .catch(function (e) { console.error(e) });
                }
                
                //#region Metodos para la lista de precios
                $scope.openListaDePrecios = function () {
                    var datos = null;
                    focaModalPrecioCondicionService.getAllListaPrecio()
                    .then(function (res) {
                        datos = res.data;
                        focaModalService.modal({
                            titulo: 'Lista de precios',
                            data: datos,
                            size: 'md',
                            columnas: [
                                {
                                    propiedad: 'ID',
                                    nombre: 'Codigo'
                                },
                                {
                                    propiedad: 'DES',
                                    NOMBRE: 'Nombre'
                                }
                            ],
                        }).then(function (res) {
                            focaModalService.confirm('¿Desea cambiar la lista de precios?\n'+
                            'Se perderan los productos ingresados').then(function (data){
                                if (data) {
                                    if ($scope.notaPedido) {
                                        if ($scope.notaPedido.articulosNotaPedido.length > 0) {
                                            $scope.notaPedido.articulosNotaPedido = [];
                                        }
                                    } else if ($scope.remito) {
                                        if ($scope.remito.articulosRemito.length > 0) {
                                            $scope.remito.articulosRemito = [];
                                        }
                                    }
                                    $scope.associatedList = false;
                                    $scope.listaDePreciosAlternativa = res;
                                }
                            });
                        }).catch(function (e) {
                                console.error(e);
                            });
                        });
                };
                $scope.selectListaDePrecios = function () {
                    $scope.associatedList = true;
                };
                $scope.verListaProductos = function (id) {
                    $uibModal.open(
                        {
                            ariaLabelledBy: 'Busqueda de Productos',
                            templateUrl: 'modal-busqueda-productos.html',
                            controller: 'modalBusquedaProductosCtrl',
                            resolve: {
                                parametroProducto: {
                                    idLista: parseInt(id),
                                    cotizacion: 1,
                                    simbolo: '$',
                                    soloMostrar: true
                                }
                            },
                            size: 'md'
                        }
                    );
                };
                //#endregion

                //#region Metodos para los plazos
                $scope.addPlazo = function (key) {
                    if (key != 13) return;
                    if ($scope.plazos.length === 100) return;
                    for (var i = 1; i < $scope.plazos.length; i++) {
                        if ($scope.plazos[0].dias == $scope.plazos[i].dias && $scope.plazos[i].activo == true) {
                            focaModalService.alert("Ya existe un plazo con este valor");
                            return;
                        }
                    }
                    $scope.plazos.unshift({ dias: 0, idCliente: parametros.idCliente, activo: true });
                    $scope.focused = 1;
                };
                $scope.deletePlazo = function (index) {
                    $scope.plazos[index].activo = false;
                };
                $scope.validateMinMax = function (plazo, min, max) {
                    plazo.dias = parseInt(plazo.dias);
                    if (plazo.dias === null || plazo.dias === undefined || isNaN(plazo.dias)) {
                        plazo.dias = '0';
                        return;
                    }
                    if (parseInt(plazo.dias) < min) {
                        plazo.dias = '0';
                        return;
                    }
                    if (parseInt(plazo.dias) > max) {
                        plazo.dias = '365';
                        return;
                    }
                };
                //#endregion

                $scope.closeModalPrecioCondicion = function () {
                    $uibModalInstance.dismiss('cancel');
                };
                $scope.guardarPrecioCondicion = function () {
                        $scope.plazos.shift();
                        focaModalPrecioCondicionService.createPlazo($scope.plazos)
                            .then(function () {
                                var precioCondicion = {
                                    listaPrecio: $scope.associatedList ? $scope.listaDePreciosAsociada : $scope.listaDePreciosAlternativa,
                                    plazoPago: $filter('filter')($scope.plazos, { activo: true }, true)
                                };
                                $uibModalInstance.close(precioCondicion);
                            })
                            .catch(function (e) { console.error(e) })
                };
            }
        ]);
