angular.module('focaModalPrecioCondicion')
    .service('focaModalPrecioCondicionService', [
        '$http',
        'API_ENDPOINT',
        function ($http, API_ENDPOINT) {
            return {
                getPlazosByIdPrecioCondicion: function (id) {
                    return $http.get(API_ENDPOINT.URL + '/plazo-pago/precio-condicion/' + id);
                },
                getPreciosCondiciones: function () {
                    return $http.get(API_ENDPOINT.URL + '/precio-condicion/plazo-pago');
                },
                getPreciosCondicionesByIdListaPrecio: function (idListaPrecio) {
                    return $http.get(API_ENDPOINT.URL + '/precio-condicion/plazo-pago/' +
                        idListaPrecio);
                },
                getListaPrecio: function (idListaPrecio) {
                    return $http.get(API_ENDPOINT.URL + '/lista-precio/' +
                        idListaPrecio);
                },
                getAllListaPrecio: function () {
                    return $http.get(API_ENDPOINT.URL + '/lista-precio');
                },
                getPlazosByIdCliente: function (id) {
                    return $http.get(API_ENDPOINT.URL + '/plazo-pago/cliente/' + id);
                },
                createPlazo: function (plazosPago){
                    return $http.post(API_ENDPOINT.URL + '/plazos-pago', { plazosPago: plazosPago });                    
                },
                actualizarLista: function(id , mod) {
                    return $http.post(API_ENDPOINT.URL + '/cliente/update/mod', { id: id, mod: mod}); 
                }
            };
        }
    ]);
