const clean         = require('gulp-clean');
const concat        = require('gulp-concat');
const connect       = require('gulp-connect');
const gulp          = require('gulp');
const htmlmin       = require('gulp-htmlmin');
const jshint        = require('gulp-jshint');
const pump          = require('pump');
const rename        = require('gulp-rename');
const replace       = require('gulp-replace');
const templateCache = require('gulp-angular-templatecache');
const uglify        = require('gulp-uglify-es').default;
const sass          = require('gulp-sass');

var paths = {
    dist:     'dist/',
    srcJS:    'src/js/*.js',
    srcViews: 'src/views/*.html',
    tmp:      'tmp'
};

gulp.task('templates', function() {
    return pump(
        [
            gulp.src(paths.srcViews),
            htmlmin(),
            templateCache('views.js', {
                module: 'focaTeclado',
                root: ''
            }),
            gulp.dest(paths.tmp)
        ]
    );
});

gulp.task('sass', function() {
    return gulp.src('src/sass/*.scss')
    .pipe(sass({outputStyle: 'compressed'}).on('error', sass.logError))
    .pipe(gulp.dest('css'));
});

gulp.task('uglify', ['templates'], function() {
    return pump(
        [
            gulp.src([
                paths.srcJS,
                'tmp/views.js'
            ]),
            concat('foca-teclado.js'),
            replace('src/views/', ''),
            replace("'ngSanitize', 'onScreenKeyboard'", ''),
            gulp.dest(paths.tmp),
            rename('foca-teclado.min.js'),
            uglify(),
            gulp.dest(paths.dist)
        ]
    );
});

gulp.task('clean', function() {
    return gulp.src(['tmp', 'dist'], {read: false})
    .pipe(clean());
});

gulp.task('pre-commit', function() {
    pump(
        [
            gulp.src(paths.srcJS),
            jshint('.jshintrc'),
            jshint.reporter('default'),
            jshint.reporter('fail')
        ]
    );
});
 
gulp.task('webserver', function() {
    pump [
        connect.server(
            {
                port: 3000
            }
        )
    ]
});

gulp.task('clean-post-install', function() {
    return gulp.src(['src', 'tmp', '.jshintrc','readme.md', '.gitignore', 'gulpfile.js',
                     'index.html'], {read: false})
    .pipe(clean());
});

gulp.task('default', ['webserver']);

gulp.task('watch', function() {
    gulp.watch([paths.srcJS, paths.srcViews], ['uglify']);
});
