angular.module('focaBusquedaCliente')
    .controller('focaBusquedaClienteModalController', [
        '$uibModalInstance', 'focaBusquedaClienteService', '$scope', '$filter',
        '$uibModal', 'focaModalService', '$timeout', 'vendedor',
        function($uibModalInstance, focaBusquedaClienteService, $scope, $filter,
            $uibModal, focaModalService, $timeout, vendedor) {

            $scope.vendedor = vendedor ? vendedor : {};
            $scope.filters = '';
            $scope.primerBusqueda = false;
            // pagination
            $scope.numPerPage = 10;
            $scope.currentPage = 1;
            $scope.filteredClientes = [];
            $scope.currentPageClientes = [];
            $scope.selectedClientes = -1;
            $scope.ingreso = false;
            $scope.regexCuit = new RegExp(/\b(20|23|24|27|30|33|34)(\D)?[0-9]{8}(\D)?[0-9]/g);
            $scope.focused = 1;

            $scope.cliente = {
                COD: 0,
                ES_MAY: true,
                provincia: {
                    NOMBRE: ''
                },
                localidad: {
                    NOMBRE: ''
                },
                iva: {
                    NOMBRE: ''
                },
                actividad: {
                    NOM: ''
                },
                zona: {
                    NOM: ''
                },
                tipoFactura: {
                    NOMBRE: ''
                },
                tipoComprobante: {
                    NOMBRE: ''
                },
                formaPago: {
                    NOMBRE: ''
                },
                cobrador: {
                    NomVen: ''
                }
            };

            $scope.busquedaPress = function(key) {
                if (key === 13) {
                    var funcion = ($scope.vendedor.id) ?
                        'obtenerClientesPorNombreOCuitByVendedor' : 'obtenerClientesPorNombreOCuit';

                    $scope.searchLoading = true;
                    focaBusquedaClienteService
                        [funcion]($scope.filters, $scope.vendedor.id)
                        .then(
                            function(res) {
                                $scope.primerBusqueda = true;
                                $scope.clientes = res.data;
                                $scope.search(true);
                                primera();
                                $scope.searchLoading = false;
                        });
                }
            };

            $scope.search = function (pressed) {
                if($scope.primerBusqueda) {
                    $scope.filteredClientes = $filter('filter')(
                        $scope.clientes, {$: $scope.filters}
                    );

                    if(pressed && $scope.filteredClientes.length === 0){
                        $timeout(function() {
                            angular.element('#search')[0].focus();
                            $scope.filters = '';
                        });
                    }

                    $scope.lastPage = Math.ceil(
                        $scope.filteredClientes.length / $scope.numPerPage
                    );

                    $scope.resetPage();
                }
            };

            $scope.resetPage = function () {
                $scope.currentPage = 1;
                $scope.selectPage(1);
            };

            $scope.selectPage = function (page) {
                var start = (page - 1) * $scope.numPerPage;
                var end = start + $scope.numPerPage;
                $scope.paginas = [];
                $scope.paginas = calcularPages(page);
                $scope.currentPageClientes = $scope.filteredClientes.slice(start, end);
                $scope.currentPage = page;
            };

            $scope.select = function(cliente, esNuevo = false) {
                cliente.esNuevo = esNuevo;
                $uibModalInstance.close(cliente);
            };

            $scope.cancel = function() {
                if($scope.ingreso) {
                    $scope.ingreso = false;
                }else {
                    $uibModalInstance.dismiss('cancel');
                }
            };

            $scope.busquedaDown = function(key) {
                if (key === 40) {
                    primera(key);
                }
            };

            $scope.itemCliente = function(key) {
                if (key === 38) {
                    anterior(key);
                }

                if (key === 40) {
                    siguiente(key);
                }

                if (key === 37) {
                    retrocederPagina();
                }

                if (key === 39) {
                    avanzarPagina();
                }
            };

            $scope.focus = function(val) {
                $scope.focused = val;
            };

            $scope.next = function(key) {
                if (key === 13) $scope.focused++;
            };

            $scope.seleccionarProvincia = function(key) {
                if(key === 13) {
                    var parametrosModal = {
                        query: '/provincia',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Codigo',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3}
                                },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo:'Búsqueda de provincias',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(function(provincia) {
                        $scope.cliente.provincia = provincia;
                        $timeout(function() {
                            $scope.focused = 5;
                        });
                    }, function() {
                        //TODO: función llamada cuando cancela el modal
                    });
                }
            };
            $scope.seleccionarLocalidad = function(key) {
                if($scope.cliente.provincia.ID === undefined) {
                    focaModalService.alert('Seleccione una provincia');
                    return;
                }
                if(key === 13) {
                    var parametrosModal = {
                        query: '/localidad/' + $scope.cliente.provincia.ID,
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo:'Búsqueda de localidades',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(function(localidad) {
                        $scope.cliente.localidad = localidad;
                        $timeout(function() {
                            $scope.focused = 6;
                        });
                    }, function() {
                        //TODO: función llamada cuando cancela el modal
                    });
                }
            };
            $scope.seleccionarIva = function(key) {
                if(key === 13) {
                    var parametrosModal = {
                        query: '/iva',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo:'Búsqueda de responsabilidad ante el IVA',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function(iva) {
                            $scope.cliente.iva = iva;
                            $timeout(function() {
                                $scope.focused = 10;
                            });
                        }, function() {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarActividad = function(key) {
                if(key === 13) {
                    var parametrosModal = {
                        query: '/actividad',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOM',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de actividades',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function(actividad) {
                            $scope.cliente.actividad = actividad;
                            $timeout(function() {
                                $scope.focused = 8;
                            });
                        }, function() {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarZona = function(key) {
                if(key === 13) {
                    var parametrosModal = {
                        query: '/zona',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOM',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de zonas',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function(zona) {
                            $scope.cliente.zona = zona;
                            $timeout(function() {
                                $scope.focused = 7;
                            });
                        }, function() {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarTipoFactura = function(key) {
                if(key === 13) {
                    var parametrosModal = {
                        query: '/tipo-factura',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código'
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de tipos de factura',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function(tipoFactura) {
                            $scope.cliente.tipoFactura = tipoFactura;
                            $timeout(function() {
                                $scope.focused = 11;
                            });
                        }, function() {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarTipoComprobante = function(key) {
                if(key === 13) {
                    var parametrosModal = {
                        query: '/tipo-comprobante',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código'
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de tipos de comprobante',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function(tipoComprobante) {
                            $scope.cliente.tipoComprobante = tipoComprobante;
                            $timeout(function() {
                                $scope.focused = 13;
                            });
                        }, function() {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarFormaPago = function(key) {
                if(key === 13) {
                    var parametrosModal = {
                        query: '/forma-pago',
                        columnas: [
                            {
                                propiedad: 'ID',
                                nombre: 'Código',
                                filtro: {
                                    nombre: 'rellenarDigitos',
                                    parametro: 3
                                }
                            },
                            {
                                propiedad: 'NOMBRE',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de formas de pago',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function(formaPago) {
                            $scope.cliente.formaPago = formaPago;
                        }, function() {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };
            $scope.seleccionarCobrador = function(key) {
                if(key === 13) {
                    var parametrosModal = {
                        query: '/cobrador',
                        columnas: [
                            {
                                propiedad: 'NUM',
                                nombre: 'Código'
                            },
                            {
                                propiedad: 'NOM',
                                nombre: 'Nombre'
                            }
                        ],
                        titulo: 'Búsqueda de cobradores',
                        size: 'md'
                    };
                    focaModalService.modal(parametrosModal).then(
                        function(cobrador) {
                            $scope.cliente.cobrador = cobrador;
                        }, function() {
                            // funcion ejecutada cuando se cancela el modal
                        });
                }
            };

            $scope.guardar = function() {

                $scope.cliente.PCX = $scope.cliente.provincia.ID;
                $scope.cliente.LOX = $scope.cliente.localidad.ID;
                $scope.cliente.IVA = $scope.cliente.iva.ID;
                $scope.cliente.ACT = $scope.cliente.actividad.ID;
                $scope.cliente.ZON = $scope.cliente.zona.ID;
                $scope.cliente.TIP = $scope.cliente.tipoFactura.ID;
                $scope.cliente.TCO = $scope.cliente.tipoComprobante.ID;
                $scope.cliente.FPA = $scope.cliente.formaPago.ID;
                $scope.cliente.VEN = $scope.vendedor.id;
                $scope.cliente.idCobrador = $scope.cliente.cobrador.id;

                delete $scope.cliente.provincia;
                delete $scope.cliente.localidad;
                delete $scope.cliente.iva;
                delete $scope.cliente.actividad;
                delete $scope.cliente.zona;
                delete $scope.cliente.tipoFactura;
                delete $scope.cliente.tipoComprobante;
                delete $scope.cliente.formaPago;
                delete $scope.cliente.cobrador;

                focaBusquedaClienteService
                    .guardarCliente($scope.cliente)
                    .then(function(res) {
                        var cliente = {
                            cod: res.data.COD,
                            cuit: res.data.CUIT,
                            esNuevo: res.data.esNuevo,
                            nom: res.data.NOM
                        };
                        $scope.select(cliente, true);
                    });
            };

            function calcularPages(paginaActual) {
                var paginas = [];
                paginas.push(paginaActual);

                if (paginaActual - 1 > 1) {
                    
                    paginas.unshift(paginaActual - 1);
                    if (paginaActual - 2 > 1) {
                        paginas.unshift(paginaActual - 2);
                    }
                }

                if (paginaActual + 1 < $scope.lastPage) {
                    paginas.push(paginaActual + 1);
                    if (paginaActual + 2 < $scope.lastPage) {
                        paginas.push(paginaActual + 2);
                    }
                }

                if (paginaActual !== 1) {
                    paginas.unshift(1);
                }

                if (paginaActual !== $scope.lastPage) {
                    paginas.push($scope.lastPage);
                }

                return paginas;
            }

            function primera() {
                $scope.selectedClientes = 0;
            }

            function anterior() {
                if ($scope.selectedClientes === 0 && $scope.currentPage > 1) {
                    retrocederPagina();
                } else {
                    $scope.selectedClientes--;
                }
            }

            function siguiente() {
                if ($scope.selectedClientes < $scope.currentPageClientes.length - 1 ) {
                    $scope.selectedClientes++;
                } else {
                        avanzarPagina();
                }
            }

            function retrocederPagina() {
                if ($scope.currentPage > 1) {
                    $scope.selectPage($scope.currentPage - 1);
                    $scope.selectedClientes = $scope.numPerPage - 1;
                }
            }

            function avanzarPagina() {
                if ($scope.currentPage < $scope.lastPage) {
                    $scope.selectPage($scope.currentPage + 1);
                    $scope.selectedClientes = 0;
                }
            }
        }
    ]);
