angular.module('focaCrearLogin')
    .controller('focaCrearLoginController', [
        '$scope', '$timeout', '$uibModal', 'focaCrearLoginService','focaBotoneraLateralService',
        function($scope, $timeout, $uibModal, focaCrearLoginService, focaBotoneraLateralService) {
            config();

            //METODOS
            function init() {
                $scope.numPerPage = 9;
                $scope.now = new Date();
                $scope.seleccionado = '';
                $scope.cuentas = [];
                $scope.currentPageUsuarios = [];
                $scope.$broadcast('removeCabecera', {
                    label: 'Selección:',
                    valor: $scope.seleccionado
                });
            }

            function config() {
                $scope.botonera = [
                    {
                        label: 'Transportista',
                        image: 'cliente.png'
                    },
                    {
                        label: 'Cobrador',
                        image: 'cliente.png'
                    },
                    {
                        label: 'Vendedor',
                        image: 'cliente.png'
                    }
                ];
                
                $timeout(function() {
                    focaBotoneraLateralService.showSalir(true);
                    focaBotoneraLateralService.showPausar(false);
                    focaBotoneraLateralService.showCancelar(false);
                    focaBotoneraLateralService.showGuardar(false);
                });

                init();
            }

            $scope.seleccionarTransportista = function() {
                $scope.seleccionado = 'Transportistas';
                
                focaCrearLoginService.getListaChoferes().then(setearTabla);
            };

            $scope.seleccionarCobrador = function() {
                $scope.seleccionado = 'Cobradores';
                
                focaCrearLoginService.getListaCobradores().then(setearTabla);
            };

            $scope.seleccionarVendedor = function() {
                $scope.seleccionado = 'Vendedores';
                
                focaCrearLoginService.getListaVendedores().then(setearTabla);
            };

            $scope.openModalAcceso = function(cuenta) {
                var parametros = {
                    cuenta: cuenta,
                    tipo: $scope.seleccionado
                };
                
                var modalInstance = $uibModal.open(
                    {
                        ariaLabelledBy: 'Configuracion de Logueo',
                        templateUrl: 'modal-login.html',
                        controller: 'focaModalLoginController',
                        size: 'md',
                        resolve: {
                            parametros: function() {
                                return parametros;
                            }
                        }
                    }
                );
                
                modalInstance.result.then(
                    function(result) {
                        init();
                    }, function() {}
                );
            };

            $scope.selectPage = function(page) {
                var start = (page - 1) * $scope.numPerPage;
                var end = start + $scope.numPerPage;
                $scope.paginas = [];
                $scope.paginas = calcularPages(page);
                $scope.currentPageUsuarios =
                    $scope.cuentas.slice(start, end);
                $scope.currentPage = page;
            };

            $scope.resetPage = function() {
                $scope.currentPage = 1;
                $scope.selectPage(1);
            };

            function setearTabla(datos) {
                $scope.cuentas = datos.data;

                $scope.lastPage = Math.ceil(
                    $scope.cuentas.length / $scope.numPerPage
                );
                $scope.resetPage();

                if ($scope.seleccionado == 'Cobradores' ||
                    $scope.seleccionado == 'Vendedores'
                ) {
                    for (var i = $scope.cuentas.length - 1; i >= 0; i--) {  
                        $scope.cuentas[i].codigo = $scope.cuentas[i].NUM;
                        $scope.cuentas[i].nombre = $scope.cuentas[i].NOM;
                        $scope.cuentas[i].dni = $scope.cuentas[i].dni;
                    }       
                } else {
                    for (var i = $scope.cuentas.length - 1; i >= 0; i--) {
                        $scope.cuentas[i].codigo = $scope.cuentas[i].id;
                    }
                }

                $scope.$broadcast('removeCabecera', {
                    label: 'Selección:',
                    valor: $scope.seleccionado
                });
            }

            function calcularPages(paginaActual) {
                var paginas = [];
                paginas.push(paginaActual);

                if(paginaActual - 1 > 1) {
                    
                    paginas.unshift(paginaActual - 1);
                    if(paginaActual - 2 > 1) {
                        paginas.unshift(paginaActual - 2);
                    }
                }

                if(paginaActual + 1 < $scope.lastPage) {
                    paginas.push(paginaActual + 1);
                    if(paginaActual + 2 < $scope.lastPage) {
                        paginas.push(paginaActual + 2);
                    }
                }

                if(paginaActual !== 1) {
                    paginas.unshift(1);
                }

                if(paginaActual !== $scope.lastPage) {
                    paginas.push($scope.lastPage);
                }

                return paginas;
            }

            function primera() {
                $scope.selectedUsuarios = 0;
            }

            function anterior() {
                if ($scope.selectedUsuarios === 0 && $scope.currentPage > 1) {
                    retrocederPagina();
                } else {
                    $scope.selectedUsuarios--;
                }
            }

            function siguiente() {
                if ($scope.selectedUsuarios < $scope.currentPageUsuarios.length - 1 ) {
                    $scope.selectedUsuarios++;
                } else {
                    avanzarPagina();
                }
            }

            function retrocederPagina() {
                if ($scope.currentPage > 1) {
                    $scope.selectPage($scope.currentPage - 1);
                    $scope.selectedUsuarios = $scope.numPerPage - 1;
                }
            }

            function avanzarPagina() {
                if ($scope.currentPage < $scope.lastPage) {
                    $scope.selectPage($scope.currentPage + 1);
                    $scope.selectedUsuarios = 0;
                }
            }
        }
    ]);
